/* $Id: ElementInfo.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 쐬F 2004/12/12
 */
package sml_editor.controller;

import java.util.Properties;

import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

import sml_editor.node.SmlElement;


/**
 * @author kawamura
 */
public class ElementInfo {
	private SmlElement element;
	/**
	 * @param tagName
	 * @param attrs
	 */
	public ElementInfo(SmlElement elem) {
		element = elem;
	}
	
	/**
	 * 
	 * @return
	 */
	public Properties getProperties() {
		Properties attrs = new Properties();
		NamedNodeMap map = element.getNode().getAttributes();
		for(int i=0; i < map.getLength(); i++) {
			Attr attr = (Attr)map.item(i);
			String name = attr.getName();
			String value = attr.getValue();
			attrs.setProperty(name, value);
		}

		return attrs;
	}
	
	public String getTagName() {
		return element.getTagName();
	}
	
	public SmlElement getSmlElement() {
		return element;
	}
}
