/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.client;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.oauth.client.RequestWrapper;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignature;
import com.sun.jersey.oauth.signature.OAuthSignatureException;
import javax.ws.rs.ext.Providers;

public final class OAuthClientFilter
extends ClientFilter {
    private final Providers providers;
    private final OAuthParameters parameters;
    private final OAuthSecrets secrets;

    public OAuthClientFilter(Providers providers, OAuthParameters parameters, OAuthSecrets secrets) {
        this.providers = providers;
        this.parameters = parameters;
        this.secrets = secrets;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        if (this.parameters != null && this.secrets != null && !request.getHeaders().containsKey((Object)"Authorization")) {
            OAuthParameters p = (OAuthParameters)this.parameters.clone();
            if (p.getTimestamp() == null) {
                p.setTimestamp();
            }
            if (p.getNonce() == null) {
                p.setNonce();
            }
            try {
                OAuthSignature.sign((OAuthRequest)new RequestWrapper(request, this.providers), (OAuthParameters)p, (OAuthSecrets)this.secrets);
            }
            catch (OAuthSignatureException se) {
                throw new ClientHandlerException((Throwable)se);
            }
        }
        return this.getNext().handle(request);
    }
}

