/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import jp.ac.nii.hcp.client.net.ProjectContentClient;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.ClientStatus;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.client.workspace.ProjectSpace;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.model.ProjectCommitWrapper;

public class FileAttachmentManager {
    private ProjectContentClient client;
    private ProjectSpace space;

    public FileAttachmentManager(ProjectContentClient client) {
        this.client = client;
    }

    public void setSpace(ProjectSpace space) {
        this.space = space;
    }

    public boolean exists(HCPAttachment attachment) {
        return this.space.hasAttachmentFile(attachment);
    }

    public void addFileAttachment(String id, String filePath, String contentType, String description, File entity) throws IOException, UnauthorizedException, HCPClientException {
        if (contentType == null || contentType.length() == 0) {
            contentType = "application/octet-stream";
        }
        HCPAttachment attachment = new HCPAttachment(id, contentType, filePath, null, description);
        attachment.record = new HCPProjectContent.Record(0, 0, 0, null, null, null, null);
        this.addFileAttachment(attachment, entity);
    }

    public void addFileAttachment(HCPAttachment attachment, File entity) throws IOException, UnauthorizedException, HCPClientException {
        if (!attachment.validate()) {
            throw new HCPClientException(ClientStatus.CONTENT_ID_INVALID, String.format("'%s' is unavailable as content ID.", attachment.id), null);
        }
        if (!entity.exists()) {
            throw new HCPClientException(ClientStatus.FILE_ATTACHMENT_NOT_FOUND, String.format("Attachment file '%s' does not exist.", entity.getAbsolutePath()), null);
        }
        FileInputStream stream = new FileInputStream(entity);
        try {
            try {
                if (this.space.isOriginal()) {
                    throw new HCPClientException(ClientStatus.PROJECT_NOT_REGISTERED, String.format("Project '%s' is not registered in repository.", this.space.getName()), null);
                }
                ProjectCommitWrapper wrapper = this.client.addFileAttachment(attachment, stream);
                if (wrapper == null) {
                    throw new HCPClientException(ClientStatus.COMMIT_CONFLICTS, String.format("Content ID '%s' is already used in project '%s'.", attachment.id, this.space.getName()), null);
                }
                stream.close();
                stream = new FileInputStream(entity);
                this.space.addFileAttachment(wrapper.difference, stream);
            }
            catch (SQLException e) {
                throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error", e);
            }
        }
        finally {
            stream.close();
        }
    }

    public void setFileAttachment(HCPAttachment attachment, File entity) throws IOException, UnauthorizedException, HCPClientException {
        if (!entity.exists()) {
            throw new HCPClientException(ClientStatus.FILE_ATTACHMENT_NOT_FOUND, String.format("Attachment file '%s' does not exist.", entity.getAbsolutePath()), null);
        }
        FileInputStream stream = new FileInputStream(entity);
        try {
            this.upload(attachment, stream);
            stream.close();
            stream = new FileInputStream(entity);
            this.space.saveAttachmentFile(attachment, stream);
        }
        finally {
            stream.close();
        }
    }

    public void download(Iterable<HCPAttachment> attachments) throws IOException, UnauthorizedException, HCPClientException {
        this.download(attachments, false);
    }

    public void download(Iterable<HCPAttachment> attachments, boolean overwrite) throws IOException, UnauthorizedException, HCPClientException {
        for (HCPAttachment attachment : attachments) {
            InputStream data;
            if (attachment.filePath == null || !overwrite && this.space.hasAttachmentFile(attachment) || (data = this.client.downloadFileAttachment(attachment)) == null) continue;
            this.space.saveAttachmentFile(attachment, data);
            data.close();
        }
    }

    private void upload(HCPAttachment attachment, InputStream entity) throws IOException, UnauthorizedException, HCPClientException {
        this.client.uploadFileAttachment(attachment, entity);
    }
}

