/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import jp.ac.nii.hcp.client.core.ProjectEditor;
import jp.ac.nii.hcp.client.module.ModelUtility;
import jp.ac.nii.hcp.client.module.ProjectContentProcessor;
import jp.ac.nii.hcp.client.shared.ClientStatus;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.client.workspace.ProjectSpace;
import jp.ac.nii.hcp.client.workspace.RepositorySpace;
import jp.ac.nii.hcp.client.workspace.Workspace;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.ProjectDifference;

public class StandaloneWorkspaceController {
    protected Workspace workspace;

    protected StandaloneWorkspaceController(Workspace ws) {
        this.workspace = ws;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public List<HCPProject> listProjects() {
        return this.workspace.getRepositorySpace().listProjects();
    }

    public HCPProject getProject(String name) throws HCPClientException {
        try {
            return this.workspace.getRepositorySpace().getProject(name);
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, String.format("SQLite access error in project '%s'.", name), e);
        }
    }

    public boolean hasProject(String name) {
        return this.workspace.getRepositorySpace().hasProject(name);
    }

    public HCPProject createProject(String name) throws HCPClientException {
        RepositorySpace space = this.workspace.getRepositorySpace();
        HCPProject project = new HCPProject(name, 0, HCPProject.Accessibility.PRIVATE, null, null, null);
        if (!project.validate()) {
            throw new HCPClientException(ClientStatus.PROJECT_NAME_INVALID, String.format("'%s' is unavailable as project name.", name), null);
        }
        try {
            HCPProject created = space.createProject(project, true);
            if (created != null) {
                return created;
            }
            throw new HCPClientException(ClientStatus.PROJECT_ALREADY_EXISTS, String.format("Project '%s' exists in workspace.", project.name), null);
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, String.format("SQLite access error in project '%s'.", project.name), e);
        }
    }

    public void removeProject(String name) {
        this.workspace.getRepositorySpace().removeProject(name);
    }

    public void renameProject(String name, String newName) throws IOException, HCPClientException {
        if (!HCPProject.validateName((String)newName)) {
            throw new HCPClientException(ClientStatus.PROJECT_NAME_INVALID, String.format("'%s' is unavailable as project name.", newName), null);
        }
        if (this.hasProject(newName)) {
            throw new HCPClientException(ClientStatus.PROJECT_ALREADY_EXISTS, String.format("Project '%s' exists in workspace.", newName), null);
        }
        HCPProject project = this.getProject(name);
        if (project == null) {
            throw new HCPClientException(ClientStatus.PROJECT_NOT_FOUND, String.format("Project '%s' does not exist in workspace.", name), null);
        }
        if (!ModelUtility.isOriginal(project)) {
            throw new HCPClientException(ClientStatus.PROJECT_NOT_ORIGINAL, String.format("Project '%s' is already imported into repository.", name), null);
        }
        RepositorySpace space = this.workspace.getRepositorySpace();
        try {
            space.renameProject(name, newName);
        }
        catch (SQLException e) {
            throw new HCPClientException(ClientStatus.DB_ERROR, String.format("SQLite access error in project '%s'.", newName), e);
        }
    }

    public ProjectDifference status(String name) throws HCPClientException {
        RepositorySpace repositorySpace = this.workspace.getRepositorySpace();
        if (repositorySpace.hasProject(name)) {
            ProjectSpace space = repositorySpace.getProjectSpace(name);
            try {
                return space.getDifference();
            }
            catch (SQLException e) {
                throw new HCPClientException(ClientStatus.DB_ERROR, String.format("SQLite access error in project '%s'.", name), e);
            }
        }
        throw new HCPClientException(ClientStatus.PROJECT_NOT_FOUND, String.format("Project '%s' does not exist in workspace.", name), null);
    }

    public ProjectContentProcessor.Status status(String name, String id) throws HCPClientException {
        RepositorySpace repositorySpace = this.workspace.getRepositorySpace();
        if (repositorySpace.hasProject(name)) {
            ProjectSpace space = repositorySpace.getProjectSpace(name);
            try {
                return space.getStatus(id);
            }
            catch (SQLException e) {
                throw new HCPClientException(ClientStatus.DB_ERROR, String.format("SQLite access error in project '%s'.", name), e);
            }
        }
        throw new HCPClientException(ClientStatus.PROJECT_NOT_FOUND, String.format("Project '%s' does not exist in workspace.", name), null);
    }

    public ProjectEditor openProject(String name) throws HCPClientException {
        ProjectSpace space = this.workspace.getRepositorySpace().getProjectSpace(name);
        if (space != null) {
            ProjectEditor editor = new ProjectEditor(space, this.workspace.getImageSpace());
            editor.open();
            return editor;
        }
        return null;
    }
}

