/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.module;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jp.ac.nii.hcp.client.module.Constants;
import jp.ac.nii.hcp.client.module.SqliteProcessor;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.model.HCPUser;

public class ProjectContentProcessor
extends SqliteProcessor {
    public ProjectContentProcessor(Connection db) {
        super(db);
    }

    public boolean exists(String id) throws SQLException {
        ResultSet rs = this.doQuery("SELECT id FROM prj_content WHERE id = ?", new Object[]{id});
        return rs.next();
    }

    public boolean exists(String id, HCPProjectContent.ContentType type) throws SQLException {
        ResultSet rs = this.doQuery("SELECT id FROM prj_content WHERE id = ? AND type = ?", new Object[]{id, Constants.PROJECT_CTYPE.getValue((Object)type)});
        return rs.next();
    }

    public List<HCPProjectContent> listContents() throws SQLException {
        ResultSet rs = this.doQuery("SELECT * FROM prj_content", new Object[0]);
        ArrayList<HCPProjectContent> contents = new ArrayList<HCPProjectContent>();
        while (rs.next()) {
            HCPProjectContent.ContentType type = (HCPProjectContent.ContentType)Constants.PROJECT_CTYPE.findValue((Object)rs.getString("type"));
            HCPMaterial content = null;
            switch (type) {
                case MATERIAL: {
                    content = new HCPMaterial(rs.getString("id"), null, null);
                    break;
                }
                case DOCUMENT: {
                    content = new HCPDocument(rs.getString("id"), null, null);
                    break;
                }
                case ATTACHMENT: {
                    content = new HCPAttachment(rs.getString("id"), null, null, null, null);
                }
            }
            content.sequence = rs.getInt("sequence");
            content.record = new HCPProjectContent.Record(rs.getInt("revision"), 0, 0, null, null, null, null);
            contents.add((HCPProjectContent)content);
        }
        return contents;
    }

    public HCPMaterial getMaterial(String id) throws SQLException {
        ResultSet rs = this.doQuery("SELECT e.image_path, e.description, pc.* FROM edit_material AS e INNER JOIN prj_content AS pc ON e.id = pc.id WHERE pc.id = ?", new Object[]{id});
        if (rs.next()) {
            HCPMaterial model = new HCPMaterial(rs.getString("id"), rs.getString("image_path"), rs.getString("description"));
            model.sequence = rs.getInt("sequence");
            model.record = this.buildRecord(rs);
            return model;
        }
        return null;
    }

    public List<HCPMaterial> getMaterials() throws SQLException {
        ResultSet rs = this.doQuery("SELECT e.image_path, e.description, pc.* FROM edit_material AS e INNER JOIN prj_content AS pc ON e.id = pc.id ", new Object[0]);
        ArrayList<HCPMaterial> models = new ArrayList<HCPMaterial>();
        while (rs.next()) {
            HCPMaterial model = new HCPMaterial(rs.getString("id"), rs.getString("image_path"), rs.getString("description"));
            model.sequence = rs.getInt("sequence");
            model.record = this.buildRecord(rs);
            models.add(model);
        }
        return models;
    }

    public HCPDocument getDocument(String id) throws SQLException {
        ResultSet rs = this.doQuery("SELECT e.source, e.description, pc.* FROM edit_document AS e INNER JOIN prj_content AS pc ON e.id = pc.id WHERE pc.id = ?", new Object[]{id});
        if (rs.next()) {
            HCPDocument model = new HCPDocument(rs.getString("id"), rs.getString("source"), rs.getString("description"));
            model.sequence = rs.getInt("sequence");
            model.record = this.buildRecord(rs);
            return model;
        }
        return null;
    }

    public List<HCPDocument> getDocuments() throws SQLException {
        ResultSet rs = this.doQuery("SELECT e.source, e.description, pc.* FROM edit_document AS e INNER JOIN prj_content AS pc ON e.id = pc.id ", new Object[0]);
        ArrayList<HCPDocument> models = new ArrayList<HCPDocument>();
        while (rs.next()) {
            HCPDocument model = new HCPDocument(rs.getString("id"), rs.getString("source"), rs.getString("description"));
            model.sequence = rs.getInt("sequence");
            model.record = this.buildRecord(rs);
            models.add(model);
        }
        return models;
    }

    public HCPAttachment getAttachment(String id) throws SQLException {
        ResultSet rs = this.doQuery("SELECT e.content_type, e.file_path, e.source, e.description, pc.* FROM edit_attachment AS e INNER JOIN prj_content AS pc ON e.id = pc.id WHERE pc.id = ?", new Object[]{id});
        if (rs.next()) {
            HCPAttachment model = new HCPAttachment(rs.getString("id"), rs.getString("content_type"), rs.getString("file_path"), rs.getString("source"), rs.getString("description"));
            model.sequence = rs.getInt("sequence");
            model.record = this.buildRecord(rs);
            return model;
        }
        return null;
    }

    public List<HCPAttachment> getAttachments() throws SQLException {
        ResultSet rs = this.doQuery("SELECT e.content_type, e.file_path, e.source, e.description, pc.* FROM edit_attachment AS e INNER JOIN prj_content AS pc ON e.id = pc.id ", new Object[0]);
        ArrayList<HCPAttachment> models = new ArrayList<HCPAttachment>();
        while (rs.next()) {
            HCPAttachment model = new HCPAttachment(rs.getString("id"), rs.getString("content_type"), rs.getString("file_path"), rs.getString("source"), rs.getString("description"));
            model.sequence = rs.getInt("sequence");
            model.record = this.buildRecord(rs);
            models.add(model);
        }
        return models;
    }

    private HCPProjectContent.Record buildRecord(ResultSet rs) throws SQLException {
        return new HCPProjectContent.Record(rs.getInt("revision"), rs.getInt("added_rev"), 0, (Date)rs.getTimestamp("created"), new HCPUser(0, rs.getString("created_by"), null, rs.getString("creator_ln"), rs.getString("creator_fn"), null, null), (Date)rs.getTimestamp("modified"), new HCPUser(0, rs.getString("modified_by"), null, rs.getString("modifier_ln"), rs.getString("modifier_fn"), null, null));
    }

    public void addMaterial(String id, String imagePath, String description, int revision, int user) throws SQLException {
        this.addContent(id, HCPProjectContent.ContentType.MATERIAL, revision, user);
        this.doUpdate("INSERT INTO edit_material VALUES (?, ?, ?)", new Object[]{id, imagePath, description});
    }

    public void addDocument(String id, String source, String description, int revision, int user) throws SQLException {
        this.addContent(id, HCPProjectContent.ContentType.DOCUMENT, revision, user);
        this.doUpdate("INSERT INTO edit_document VALUES (?, ?, ?)", new Object[]{id, source, description});
    }

    public void addTextAttachment(String id, String source, String description, int revision, int user) throws SQLException {
        this.addContent(id, HCPProjectContent.ContentType.ATTACHMENT, revision, user);
        this.doUpdate("INSERT INTO edit_attachment VALUES (?, ?, ?, ?, ?)", new Object[]{id, "text/plain", null, source, description});
    }

    public void registerMaterial(HCPMaterial material) throws SQLException {
        this.addContent((HCPProjectContent)material);
        this.doUpdate("INSERT INTO material VALUES (?, ?, ?)", new Object[]{material.id, material.imagePath, material.description});
        this.doUpdate("INSERT INTO edit_material VALUES (?, ?, ?)", new Object[]{material.id, material.imagePath, material.description});
    }

    public void registerDocument(HCPDocument document) throws SQLException {
        this.addContent((HCPProjectContent)document);
        this.doUpdate("INSERT INTO document VALUES (?, ?, ?)", new Object[]{document.id, document.source, document.description});
        this.doUpdate("INSERT INTO edit_document VALUES (?, ?, ?)", new Object[]{document.id, document.source, document.description});
    }

    public void registerAttachment(HCPAttachment attachment) throws SQLException {
        this.addContent((HCPProjectContent)attachment);
        this.doUpdate("INSERT INTO attachment VALUES (?, ?, ?, ?, ?)", new Object[]{attachment.id, attachment.contentType, attachment.filePath, attachment.source, attachment.description});
        this.doUpdate("INSERT INTO edit_attachment VALUES (?, ?, ?, ?, ?)", new Object[]{attachment.id, attachment.contentType, attachment.filePath, attachment.source, attachment.description});
    }

    private void addContent(String id, HCPProjectContent.ContentType type, int revision, int user) throws SQLException {
        Date now = new Date();
        this.doUpdate("INSERT INTO prj_content (sequence, id, type, revision, added_rev, created, created_by, modified, modified_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{0, id, Constants.PROJECT_CTYPE.getValue((Object)type), revision, revision, now, user, now, user});
    }

    private void addContent(HCPProjectContent content) throws SQLException {
        String sql = "INSERT INTO prj_content (sequence, id, type, revision, added_rev, created, created_by, creator_ln, creator_fn, modified, modified_by, modifier_ln, modifier_fn) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        HCPProjectContent.Record record = content.record;
        this.doUpdate(sql, new Object[]{content.sequence, content.id, Constants.PROJECT_CTYPE.getValue((Object)content.type), record.revision, record.added, record.created, record.createdBy.id, record.createdBy.lastName, record.createdBy.firstName, record.modified, record.modifiedBy.id, record.modifiedBy.lastName, record.modifiedBy.firstName});
    }

    public boolean setDocument(String id, String source) throws SQLException {
        this.doUpdate("UPDATE edit_document SET source = ? WHERE id = ?", new Object[]{source, id});
        return this.getAffectedRows() == 1;
    }

    public boolean setTextAttachment(String id, String source) throws SQLException {
        this.doUpdate("UPDATE edit_attachment SET source = ? WHERE id = ? AND file_path IS NULL", new Object[]{source, id});
        return this.getAffectedRows() == 1;
    }

    public boolean setFileAttachment(String id, String contentType) throws SQLException {
        this.doUpdate("UPDATE edit_attachment SET content_type = ? WHERE id = ? AND file_path IS NOT NULL", new Object[]{contentType, id});
        return this.getAffectedRows() == 1;
    }

    public void deleteMaterial(String id) throws SQLException {
        this.doUpdate("DELETE FROM edit_material WHERE id = ?", new Object[]{id});
        ResultSet rs = this.doQuery("SELECT id FROM material WHERE id = ?", new Object[]{id});
        if (!rs.next()) {
            this.doUpdate("DELETE FROM prj_content WHERE id = ? AND type = ?", new Object[]{id, Constants.PROJECT_CTYPE.getValue((Object)HCPProjectContent.ContentType.MATERIAL)});
        }
    }

    public void deleteDocument(String id) throws SQLException {
        this.doUpdate("DELETE FROM edit_document WHERE id = ?", new Object[]{id});
        ResultSet rs = this.doQuery("SELECT id FROM document WHERE id = ?", new Object[]{id});
        if (!rs.next()) {
            this.doUpdate("DELETE FROM prj_content WHERE id = ? AND type = ?", new Object[]{id, Constants.PROJECT_CTYPE.getValue((Object)HCPProjectContent.ContentType.DOCUMENT)});
        }
    }

    public void deleteAttachment(String id) throws SQLException {
        this.doUpdate("DELETE FROM edit_attachment WHERE id = ?", new Object[]{id});
        ResultSet rs = this.doQuery("SELECT id FROM attachment WHERE id = ?", new Object[]{id});
        if (!rs.next()) {
            this.doUpdate("DELETE FROM prj_content WHERE id = ? AND type = ?", new Object[]{id, Constants.PROJECT_CTYPE.getValue((Object)HCPProjectContent.ContentType.ATTACHMENT)});
        }
    }

    public List<String> deleteContents(List<HCPProjectContent> contents) throws SQLException {
        ArrayList<String> materialIds = new ArrayList<String>();
        ArrayList<String> documentIds = new ArrayList<String>();
        ArrayList<String> attachmentIds = new ArrayList<String>();
        for (HCPProjectContent content : contents) {
            switch (content.type) {
                case MATERIAL: {
                    materialIds.add(content.id);
                    break;
                }
                case DOCUMENT: {
                    documentIds.add(content.id);
                    break;
                }
                case ATTACHMENT: {
                    attachmentIds.add(content.id);
                }
            }
        }
        this.deleteMaterials(materialIds);
        this.deleteDocuments(documentIds);
        List<String> filesToDelete = this.deleteAttachments(attachmentIds);
        return filesToDelete;
    }

    private void deleteMaterials(List<String> ids) throws SQLException {
        StringBuffer sql = new StringBuffer("DELETE FROM prj_content WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(")");
        this.doUpdate(sql.toString(), ids);
        sql.delete(0, sql.length()).append("DELETE FROM edit_material WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(")");
        this.doUpdate(sql.toString(), ids);
        sql.delete(0, sql.length()).append("DELETE FROM material WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(")");
        this.doUpdate(sql.toString(), ids);
    }

    private void deleteDocuments(List<String> ids) throws SQLException {
        StringBuffer sql = new StringBuffer("DELETE FROM prj_content WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(")");
        this.doUpdate(sql.toString(), ids);
        sql.delete(0, sql.length()).append("DELETE FROM edit_document WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(")");
        this.doUpdate(sql.toString(), ids);
        sql.delete(0, sql.length()).append("DELETE FROM document WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(")");
        this.doUpdate(sql.toString(), ids);
    }

    private List<String> deleteAttachments(List<String> ids) throws SQLException {
        ArrayList<String> deletedFiles = new ArrayList<String>();
        StringBuffer sql = new StringBuffer("SELECT file_path FROM attachment WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(") AND file_path IS NOT NULL");
        ResultSet rs = this.doQuery(sql.toString(), ids);
        while (rs.next()) {
            deletedFiles.add(rs.getString("file_path"));
        }
        sql.delete(0, sql.length()).append("DELETE FROM prj_content WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(")");
        this.doUpdate(sql.toString(), ids);
        sql.delete(0, sql.length()).append("DELETE FROM edit_attachment WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(")");
        this.doUpdate(sql.toString(), ids);
        sql.delete(0, sql.length()).append("DELETE FROM attachment WHERE id IN (");
        this.appendHolderString(ids.size(), null, sql);
        sql.append(")");
        this.doUpdate(sql.toString(), ids);
        return deletedFiles;
    }

    public void updateMaterial(HCPMaterial material) throws SQLException {
        this.updateContent((HCPProjectContent)material);
        this.doUpdate("UPDATE material SET description = ? WHERE id = ?", new Object[]{material.description, material.id});
        ResultSet rs = this.doQuery("SELECT id FROM edit_material WHERE id = ?", new Object[]{material.id});
        if (rs.next()) {
            this.doUpdate("UPDATE edit_material SET description = ? WHERE id = ?", new Object[]{material.description, material.id});
        } else {
            this.doUpdate("INSERT INTO edit_material (id, image_path, description) VALUES (?, ?, ?)", new Object[]{material.id, material.imagePath, material.description});
        }
    }

    public void updateDocument(HCPDocument document) throws SQLException {
        this.updateContent((HCPProjectContent)document);
        this.doUpdate("UPDATE document SET source = ?, description = ? WHERE id = ?", new Object[]{document.source, document.description, document.id});
        ResultSet rs = this.doQuery("SELECT id FROM edit_document WHERE id = ?", new Object[]{document.id});
        if (rs.next()) {
            this.doUpdate("UPDATE edit_document SET source = ?, description = ? WHERE id = ?", new Object[]{document.source, document.description, document.id});
        } else {
            this.doUpdate("INSERT INTO edit_document (id, source, description) VALUES (?, ?, ?)", new Object[]{document.id, document.source, document.description});
        }
    }

    public void updateAttachment(HCPAttachment attachment) throws SQLException {
        this.updateContent((HCPProjectContent)attachment);
        this.doUpdate("UPDATE attachment SET content_type = ?, file_path = ?, source = ?, description = ? WHERE id = ?", new Object[]{attachment.contentType, attachment.filePath, attachment.source, attachment.description, attachment.id});
        ResultSet rs = this.doQuery("SELECT id FROM edit_attachment WHERE id = ?", new Object[]{attachment.id});
        if (rs.next()) {
            this.doUpdate("UPDATE edit_attachment SET content_type = ?, file_path = ?, source = ?, description = ? WHERE id = ?", new Object[]{attachment.contentType, attachment.filePath, attachment.source, attachment.description, attachment.id});
        } else {
            this.doUpdate("INSERT INTO edit_attachment (id, content_type, file_path, source, description) VALUES (?, ?, ?)", new Object[]{attachment.id, attachment.contentType, attachment.filePath, attachment.source, attachment.description});
        }
    }

    private void updateContent(HCPProjectContent content) throws SQLException {
        this.doUpdate("UPDATE prj_content SET revision = ?, added_rev = ?, created = ?, created_by = ?, creator_ln = ?, creator_fn = ?, modified = ?, modified_by = ?, modifier_ln = ?, modifier_fn = ? WHERE id = ?", new Object[]{content.record.revision, content.record.added, content.record.created, content.record.createdBy.id, content.record.createdBy.lastName, content.record.createdBy.firstName, content.record.modified, content.record.modifiedBy.id, content.record.modifiedBy.lastName, content.record.modifiedBy.firstName, content.id});
    }

    public void setDescription(String id, String description) throws SQLException {
        HCPProjectContent.ContentType type = this.getType(id);
        switch (type) {
            case MATERIAL: {
                this.doUpdate("UPDATE edit_material SET description = ? WHERE id = ?", new Object[]{description, id});
                break;
            }
            case DOCUMENT: {
                this.doUpdate("UPDATE edit_document SET description = ? WHERE id = ?", new Object[]{description, id});
                break;
            }
            case ATTACHMENT: {
                this.doUpdate("UPDATE edit_attachment SET description = ? WHERE id = ?", new Object[]{description, id});
            }
        }
    }

    public void revertContent(String id) throws SQLException {
        Status status = this.getStatus(id);
        HCPProjectContent.ContentType type = this.getType(id);
        block0 : switch (status) {
            case ADDED: {
                break;
            }
            case MODIFIED: {
                switch (type) {
                    case MATERIAL: {
                        this.doUpdate("DELETE FROM edit_material WHERE id = ?", new Object[]{id});
                        this.doUpdate("INSERT INTO edit_material SELECT * FROM material WHERE id = ?", new Object[]{id});
                        break;
                    }
                    case DOCUMENT: {
                        this.doUpdate("DELETE FROM edit_document WHERE id = ?", new Object[]{id});
                        this.doUpdate("INSERT INTO edit_document SELECT * FROM document WHERE id = ?", new Object[]{id});
                        break;
                    }
                    case ATTACHMENT: {
                        this.doUpdate("DELETE FROM edit_attachment WHERE id = ?", new Object[]{id});
                        this.doUpdate("INSERT INTO edit_attachment SELECT * FROM attachment WHERE id = ?", new Object[]{id});
                    }
                }
                break;
            }
            case DELETED: {
                switch (type) {
                    case MATERIAL: {
                        this.doUpdate("INSERT INTO edit_material SELECT * FROM material WHERE id = ?", new Object[]{id});
                        break block0;
                    }
                    case DOCUMENT: {
                        this.doUpdate("INSERT INTO edit_document SELECT * FROM document WHERE id = ?", new Object[]{id});
                        break block0;
                    }
                    case ATTACHMENT: {
                        this.doUpdate("INSERT INTO edit_attachment SELECT * FROM attachment WHERE id = ?", new Object[]{id});
                    }
                }
            }
        }
    }

    public HCPProjectContent.ContentType getType(String id) throws SQLException {
        ResultSet rs = this.doQuery("SELECT type FROM prj_content WHERE id = ?", new Object[]{id});
        if (rs.next()) {
            String typeString = rs.getString("type");
            return (HCPProjectContent.ContentType)Constants.PROJECT_CTYPE.findValue((Object)typeString);
        }
        return null;
    }

    public Status getStatus(String id) throws SQLException {
        HCPProjectContent.ContentType type = this.getType(id);
        ResultSet crs = null;
        ResultSet ers = null;
        boolean cExists = false;
        boolean eExists = false;
        boolean match = false;
        switch (type) {
            case MATERIAL: {
                crs = this.doQuery("SELECT description FROM material WHERE id = ?", new Object[]{id});
                ers = this.doQuery("SELECT description FROM edit_material WHERE id = ?", new Object[]{id});
                cExists = crs.next();
                eExists = ers.next();
                if (!cExists || !eExists) break;
                String cdesc = crs.getString("description");
                String edesc = ers.getString("description");
                match = cdesc.equals(edesc);
                break;
            }
            case DOCUMENT: {
                String edesc;
                crs = this.doQuery("SELECT source, description FROM document WHERE id = ?", new Object[]{id});
                ers = this.doQuery("SELECT source, description FROM edit_document WHERE id = ?", new Object[]{id});
                cExists = crs.next();
                eExists = ers.next();
                if (!cExists || !eExists) break;
                String csource = crs.getString("source");
                String esource = ers.getString("source");
                String cdesc = crs.getString("description");
                match = cdesc.equals(edesc = ers.getString("description")) && csource.equals(esource);
                break;
            }
            case ATTACHMENT: {
                String edesc;
                crs = this.doQuery("SELECT source, content_type, description FROM attachment WHERE id = ?", new Object[]{id});
                ers = this.doQuery("SELECT source, content_type, description FROM edit_attachment WHERE id = ?", new Object[]{id});
                cExists = crs.next();
                eExists = ers.next();
                if (!cExists || !eExists) break;
                String csource = crs.getString("source");
                String esource = ers.getString("source");
                String cctype = crs.getString("content_type");
                String ectype = ers.getString("content_type");
                String cdesc = crs.getString("description");
                boolean bl = match = cdesc.equals(edesc = ers.getString("description")) && cctype.equals(ectype) && csource.equals(esource);
            }
        }
        if (!cExists && !eExists) {
            return Status.UNTOUCHED;
        }
        if (!cExists) {
            return Status.ADDED;
        }
        if (!eExists) {
            return Status.DELETED;
        }
        if (!match) {
            return Status.MODIFIED;
        }
        return Status.UNTOUCHED;
    }

    public Collection<HCPMaterial> getAddedMaterials(Collection<? super HCPMaterial> holder) throws SQLException {
        return this.getAddedContents(HCPMaterial.class, holder);
    }

    public Collection<HCPDocument> getAddedDocuments(Collection<? super HCPDocument> holder) throws SQLException {
        return this.getAddedContents(HCPDocument.class, holder);
    }

    public Collection<HCPAttachment> getAddedAttachments(Collection<? super HCPAttachment> holder) throws SQLException {
        return this.getAddedContents(HCPAttachment.class, holder);
    }

    public Collection<HCPMaterial> getModifiedMaterials(Collection<? super HCPMaterial> holder) throws SQLException {
        ResultSet rs = this.doQuery("SELECT e.*, pc.sequence, pc.revision FROM edit_material AS e INNER JOIN material AS c ON e.id = c.id INNER JOIN prj_content AS pc ON e.id = pc.id WHERE e.description != c.description", new Object[0]);
        ArrayList<HCPMaterial> models = holder != null ? holder : new ArrayList<HCPMaterial>();
        while (rs.next()) {
            models.add(this.createModel(rs, HCPMaterial.class));
        }
        return models;
    }

    public Collection<HCPDocument> getModifiedDocuments(Collection<? super HCPDocument> holder) throws SQLException {
        ResultSet rs = this.doQuery("SELECT e.*, pc.sequence, pc.revision FROM edit_document AS e INNER JOIN document AS c ON e.id = c.id INNER JOIN prj_content AS pc ON e.id = pc.id WHERE e.description != c.description OR e.source != c.source", new Object[0]);
        ArrayList<HCPDocument> models = holder != null ? holder : new ArrayList<HCPDocument>();
        while (rs.next()) {
            models.add(this.createModel(rs, HCPDocument.class));
        }
        return models;
    }

    public Collection<HCPAttachment> getModifiedAttachments(Collection<? super HCPAttachment> holder) throws SQLException {
        ResultSet rs = this.doQuery("SELECT e.*, pc.sequence, pc.revision FROM edit_attachment AS e INNER JOIN attachment AS c ON e.id = c.id INNER JOIN prj_content AS pc ON e.id = pc.id WHERE e.description != c.description OR (c.file_path IS NULL AND e.source != c.source) OR (c.file_path IS NOT NULL AND e.content_type != c.content_type)", new Object[0]);
        ArrayList<HCPAttachment> models = holder != null ? holder : new ArrayList<HCPAttachment>();
        while (rs.next()) {
            models.add(this.createModel(rs, HCPAttachment.class));
        }
        return models;
    }

    public Collection<HCPMaterial> getDeletedMaterials(Collection<? super HCPMaterial> holder) throws SQLException {
        return this.getDeletedContents(HCPMaterial.class, holder);
    }

    public Collection<HCPDocument> getDeletedDocuments(Collection<? super HCPDocument> holder) throws SQLException {
        return this.getDeletedContents(HCPDocument.class, holder);
    }

    public Collection<? super HCPAttachment> getDeletedAttachments(Collection<? super HCPAttachment> holder) throws SQLException {
        return this.getDeletedContents(HCPAttachment.class, holder);
    }

    public void applyCommit(String id, HCPProjectContent content, Status status) throws SQLException {
        HCPProjectContent.ContentType type = this.getType(content.id);
        switch (type) {
            case MATERIAL: {
                this.doUpdate("DELETE FROM material WHERE id = ?", new Object[]{content.id});
                if (status == Status.DELETED) break;
                this.doUpdate("INSERT INTO material SELECT * FROM edit_material WHERE id = ?", new Object[]{id});
                break;
            }
            case DOCUMENT: {
                this.doUpdate("DELETE FROM document WHERE id = ?", new Object[]{content.id});
                if (status == Status.DELETED) break;
                this.doUpdate("INSERT INTO document SELECT * FROM edit_document WHERE id = ?", new Object[]{id});
                break;
            }
            case ATTACHMENT: {
                this.doUpdate("DELETE FROM attachment WHERE id = ?", new Object[]{content.id});
                if (status == Status.DELETED) break;
                this.doUpdate("INSERT INTO attachment SELECT * FROM edit_attachment WHERE id = ?", new Object[]{id});
            }
        }
        if (status != Status.DELETED) {
            this.applyContent(content);
        } else {
            this.doUpdate("DELETE FROM prj_content WHERE id = ?", new Object[]{id});
        }
    }

    public void applyContent(HCPProjectContent content) throws SQLException {
        this.doUpdate("UPDATE prj_content SET sequence = ?, revision = ?, added_rev = ?, modified = ?, modified_by = ?, modifier_ln = ?, modifier_fn = ? WHERE id = ?", new Object[]{content.sequence, content.record.revision, content.record.added, content.record.modified, content.record.modifiedBy.id, content.record.modifiedBy.lastName, content.record.modifiedBy.firstName, content.id});
    }

    private <T extends HCPProjectContent> Collection<T> getAddedContents(Class<T> type, Collection<T> holder) throws SQLException {
        ArrayList<T> models = holder != null ? holder : new ArrayList<T>();
        String typeString = null;
        if (type.isAssignableFrom(HCPMaterial.class)) {
            typeString = "material";
        } else if (type.isAssignableFrom(HCPDocument.class)) {
            typeString = "document";
        } else if (type.isAssignableFrom(HCPAttachment.class)) {
            typeString = "attachment";
        }
        if (typeString != null) {
            String sql = "SELECT e.*, pc.sequence, pc.revision FROM edit_" + typeString + " AS e " + "INNER JOIN prj_content AS pc ON e.id = pc.id " + "WHERE NOT EXISTS (SELECT 1 FROM " + typeString + " AS c WHERE c.id = e.id)";
            ResultSet rs = this.doQuery(sql, new Object[0]);
            while (rs.next()) {
                models.add(this.createModel(rs, type));
            }
        }
        return models;
    }

    private <T extends HCPProjectContent> Collection<T> getDeletedContents(Class<T> type, Collection<T> holder) throws SQLException {
        ArrayList<T> models = holder != null ? holder : new ArrayList<T>();
        String typeString = null;
        if (type.isAssignableFrom(HCPMaterial.class)) {
            typeString = "material";
        } else if (type.isAssignableFrom(HCPDocument.class)) {
            typeString = "document";
        } else if (type.isAssignableFrom(HCPAttachment.class)) {
            typeString = "attachment";
        }
        if (typeString != null) {
            String sql = "SELECT c.*, pc.sequence, pc.revision FROM " + typeString + " AS c " + "INNER JOIN prj_content AS pc ON c.id = pc.id " + "WHERE NOT EXISTS (SELECT 1 FROM edit_" + typeString + " AS e WHERE e.id = c.id)";
            ResultSet rs = this.doQuery(sql, new Object[0]);
            while (rs.next()) {
                models.add(this.createModel(rs, type));
            }
        }
        return models;
    }

    private <T extends HCPProjectContent> T createModel(ResultSet rs, Class<T> type) throws SQLException {
        HCPMaterial content = null;
        if (type.isAssignableFrom(HCPMaterial.class)) {
            content = new HCPMaterial(rs.getString("id"), rs.getString("image_path"), rs.getString("description"));
        } else if (type.isAssignableFrom(HCPDocument.class)) {
            content = new HCPDocument(rs.getString("id"), rs.getString("source"), rs.getString("description"));
        } else if (type.isAssignableFrom(HCPAttachment.class)) {
            content = new HCPAttachment(rs.getString("id"), rs.getString("content_type"), rs.getString("file_path"), rs.getString("source"), rs.getString("description"));
        }
        content.sequence = rs.getInt("sequence");
        content.record = new HCPProjectContent.Record(rs.getInt("revision"), 0, 0, null, null, null, null);
        return (T)((HCPProjectContent)type.cast(content));
    }

    public static enum Status {
        ADDED,
        MODIFIED,
        DELETED,
        UNTOUCHED;

    }
}

