/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.net;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import com.sun.jersey.oauth.client.OAuthClientFilter;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import java.io.IOException;
import javax.ws.rs.core.MediaType;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.shared.jersey.ext.provider.OAuthTokenBodyReader;
import jp.ac.nii.hcp.shared.model.OAuthToken;

public class RepositoryConnection {
    private Client client;
    private OAuthClientFilter authFiler;

    public RepositoryConnection() {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(OAuthTokenBodyReader.class);
        config.getClasses().add(MultiPartWriter.class);
        this.client = Client.create((ClientConfig)config);
        this.authFiler = null;
    }

    public WebResource resource(String url) {
        return this.client.resource(url);
    }

    public <T> T request(String url, String method, MediaType accept, MediaType type, Class<T> responseType) throws IOException, UnauthorizedException {
        return this.request(url, method, accept, type, responseType, null);
    }

    public <T> T request(String url, String method, MediaType accept, MediaType type, Class<T> responseType, Object entity) throws IOException, UnauthorizedException {
        WebResource resource = this.client.resource(url);
        return this.request(resource, method, accept, type, responseType, entity);
    }

    public <T> T request(WebResource resource, String method, MediaType accept, MediaType type, Class<T> responseType) throws IOException, UnauthorizedException {
        return this.request(resource, method, accept, type, responseType, null);
    }

    public <T> T request(WebResource resource, String method, MediaType accept, MediaType type, Class<T> responseType, Object entity) throws IOException, UnauthorizedException {
        block10: {
            try {
                WebResource.Builder builder = resource.getRequestBuilder();
                if (accept != null) {
                    builder.accept(new MediaType[]{accept});
                }
                if (type != null) {
                    builder.type(type.toString());
                }
                if (responseType != null) {
                    return (T)(entity != null ? builder.method(method, responseType, entity) : builder.method(method, responseType));
                }
                if (entity != null) {
                    builder.method(method, entity);
                    break block10;
                }
                builder.method(method);
            }
            catch (ClientHandlerException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw e;
            }
            catch (UniformInterfaceException e) {
                if (e.getResponse().getStatus() == 401) {
                    throw new UnauthorizedException();
                }
                if (e.getResponse().getStatus() == 403) {
                    throw new UnauthorizedException();
                }
                throw e;
            }
        }
        return null;
    }

    public void setAuthentication(OAuthToken token, String signatureMethod, String consumerKey, String consumerSecret) {
        OAuthParameters params = new OAuthParameters().signatureMethod(signatureMethod).consumerKey(consumerKey);
        OAuthSecrets secrets = new OAuthSecrets().consumerSecret(consumerSecret);
        if (token != null) {
            params.token(token.token);
            params.verifier(token.verifier);
            secrets.tokenSecret(token.secret);
        }
        OAuthClientFilter filter = new OAuthClientFilter(this.client.getProviders(), params, secrets);
        this.clearAuthentication();
        this.client.addFilter((ClientFilter)filter);
        this.authFiler = filter;
    }

    public void clearAuthentication() {
        this.client.removeAllFilters();
        this.authFiler = null;
    }

    public boolean isAuthenticated() {
        return this.authFiler != null;
    }
}

