/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.environment;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.StackKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.StackObjectPool;

public class ConnectionFactory {
    private static DataSource ds = null;
    private static String _dsn = null;
    private static String _user = null;
    private static String _password = null;
    private static final String DB_VALIDATOR = "SELECT 1";

    public static void setupConnection(String dsn, String user, String password) {
        _dsn = dsn;
        _user = user;
        _password = password;
    }

    public static boolean isReady() {
        return _dsn != null && _user != null && _password != null;
    }

    public static DataSource getDataSource() {
        if (ds == null) {
            ConnectionFactory.initialize();
        }
        return ds;
    }

    public static Connection getConnection() throws SQLException {
        DataSource dataSource = ConnectionFactory.getDataSource();
        return dataSource.getConnection();
    }

    public static void close(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void initialize() {
        StackObjectPool pool = new StackObjectPool(null);
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(_dsn, _user, _password);
        StackKeyedObjectPoolFactory kopFactory = new StackKeyedObjectPoolFactory();
        new PoolableConnectionFactory((org.apache.commons.dbcp.ConnectionFactory)connFactory, (ObjectPool)pool, (KeyedObjectPoolFactory)kopFactory, DB_VALIDATOR, false, false);
        ds = new PoolingDataSource((ObjectPool)pool);
    }
}

