/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.jersey.ext;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import jp.ac.nii.hcp.shared.jersey.ext.ErrorResponseFormatter;
import jp.ac.nii.hcp.shared.jersey.ext.Named;
import jp.ac.nii.hcp.shared.service.ServiceValidationException;
import jp.ac.nii.hcp.shared.validation.Validator;

public class ValidationExFormattable {
    private static final String NAME_KEY_PREFIX = "arg.";

    public static List<List<Object>> toKeyArgs(ServiceValidationException ex) {
        Method method = ex.getMethod();
        Object[] args = ex.getArgs();
        Validator.Result[] results = ex.getResults();
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        Annotation[][] annotations = method.getParameterAnnotations();
        int i = 0;
        while (i < args.length) {
            if (results[i] != null) {
                Object[] resultArgs;
                ArrayList<Object> keyArgs = new ArrayList<Object>();
                String messageKey = results[i].type.getSimpleName();
                if (results[i].method != null && results[i].method.length() > 0) {
                    messageKey = String.valueOf(messageKey) + "." + results[i].method;
                }
                keyArgs.add(messageKey);
                keyArgs.add(ValidationExFormattable.getParameterName(annotations, i));
                Object[] objectArray = resultArgs = results[i].args;
                int n = resultArgs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object arg = objectArray[n2];
                    keyArgs.add(arg);
                    ++n2;
                }
                values.add(keyArgs);
            }
            ++i;
        }
        return values;
    }

    private static Object getParameterName(Annotation[][] annotations, int index) {
        String nameKey = null;
        if (annotations.length > index) {
            Annotation[] annotationArray = annotations[index];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                if (ann instanceof Named) {
                    nameKey = NAME_KEY_PREFIX + ((Named)ann).value();
                    break;
                }
                ++n2;
            }
        }
        if (nameKey != null) {
            return new ErrorResponseFormatter.Pack(nameKey);
        }
        return index;
    }
}

