/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.jersey.filter;

import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.oauth.server.OAuthServerRequest;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import jp.ac.nii.hcp.shared.model.OAuthToken;
import jp.ac.nii.hcp.shared.service.ServiceSession;
import jp.ac.nii.hcp.shared.service.TokenAPI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAuthRequestFilter
implements ContainerRequestFilter {
    @Context
    private HttpServletRequest servletRequest;
    public static final String AUTHORIZED_USER = "jp.ac.nii.hcp.shared.jersey.filter.OAuthRequestFilter.AuthorizedUser";
    private Log log = LogFactory.getLog(OAuthRequestFilter.class);

    public ContainerRequest filter(ContainerRequest request) {
        OAuthServerRequest oauthRequest = new OAuthServerRequest((HttpRequestContext)request);
        TokenAPI service = ServiceSession.openService(TokenAPI.class);
        try {
            OAuthToken token = service.verifyAccessRequest((OAuthRequest)oauthRequest);
            if (token == null) {
                throw new WebApplicationException(401);
            }
            this.servletRequest.setAttribute(AUTHORIZED_USER, (Object)token.user);
            this.servletRequest.setAttribute("group", (Object)token.group);
            return request;
        }
        catch (SQLException e) {
            this.log.fatal((Object)"Database error happened.", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }
}

