/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.validation;

import jp.ac.nii.hcp.shared.validation.StringOf;
import jp.ac.nii.hcp.shared.validation.ValidationAspect;
import jp.ac.nii.hcp.shared.validation.Validator;

class StringOfAspect
extends ValidationAspect<CharSequence> {
    public Integer min;
    public Integer max;
    public String regex;

    public StringOfAspect(StringOf annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
        this.regex = annotation.regex();
        if (this.regex.length() == 0) {
            this.regex = null;
        }
    }

    @Override
    protected Class<?> getType() {
        return StringOf.class;
    }

    @Override
    public Class<CharSequence> getTargetType() {
        return CharSequence.class;
    }

    @Override
    public Validator.Result validate(CharSequence arg) {
        int length = arg.length();
        if (this.min != null && length < this.min) {
            return this.ng("min", this.min);
        }
        if (this.max != null && length > this.max) {
            return this.ng("max", this.max);
        }
        if (this.regex != null) {
            String value;
            String string = value = arg instanceof String ? (String)arg : arg.toString();
            if (!value.matches(this.regex)) {
                return this.ng("regex", this.regex);
            }
        }
        return this.ok();
    }
}

