/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jp.ac.nii.hcp.shared.validation.Validate;
import jp.ac.nii.hcp.shared.validation.ValidateMethod;
import jp.ac.nii.hcp.shared.validation.ValidationAspect;
import jp.ac.nii.hcp.shared.validation.Validator;

class ValidateAspect
extends ValidationAspect<Object> {
    ValidateAspect() {
    }

    @Override
    protected Class<?> getType() {
        return Validate.class;
    }

    @Override
    public Class<Object> getTargetType() {
        return Object.class;
    }

    @Override
    public Validator.Result validate(Object arg) {
        Class<?> type = arg.getClass();
        Validate validateAnnotation = type.getAnnotation(Validate.class);
        while (validateAnnotation != null) {
            Field[] fields = type.getDeclaredFields();
            Validator.Result result = null;
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Annotation[] anns = field.getDeclaredAnnotations();
                field.setAccessible(true);
                try {
                    result = Validator.validateAnnotatedValue(field.get(arg), anns);
                }
                catch (IllegalAccessException e) {
                    throw new InternalError(String.format("Access to %s in %s is rejected.", field.getName(), arg.getClass().getName()));
                }
                if (result != null) {
                    return result;
                }
                ++n2;
            }
            Method[] methods = type.getDeclaredMethods();
            boolean status = true;
            Method[] methodArray = methods;
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                if (method.getAnnotation(ValidateMethod.class) != null && method.getReturnType() == Boolean.TYPE) {
                    try {
                        method.setAccessible(true);
                        status = (Boolean)method.invoke(arg, new Object[0]);
                    }
                    catch (Exception e) {
                        status = false;
                    }
                    if (!status) {
                        return new Validator.Result(ValidateMethod.class, method.getName(), new Object[0]);
                    }
                }
                ++n4;
            }
            type = type.getSuperclass();
            validateAnnotation = type.getAnnotation(Validate.class);
        }
        return null;
    }
}

