/* $Id: IDocumentSearcher.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * Created on 2006/08/23
 */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

import java.io.*;

import jp.ac.hokudai.meme.core_smart_gs.InvalidDataFormatException;



/**
 * @author hajime
 * <p>IDocumentSeracher は DSC ファイルを読み込んで、指定されたクエリ領域に対する検索を実行するインターフェイス</p>
 * 
 */
public interface IDocumentSearcher {

    /**
     * @deprecated dummy searcher
     */
    public static final int TYPE_DUMMY = 0;
    
    /**
     * 通常のDynamic Time Warpingを用いたアルゴリズム。WildCardは未サポート
     */
    public static final int TYPE_NORMAL = 1;
    //TODO    tmp
    public static final int TYPE_DTW_1 = 2;
    public static final int TYPE_DTW_2 = 3;
//    public static final int TYPE_DTW_3 = 4;
    
    
    
    /**
     * 
     * <p>addFileList に指定したファイルをファイルリストに追加します。</p>
     * <p>このメソッドを用いてDSCファイルを指定することで、searchメソッドが使用可能になります。</p>
     * @param addFileList 追加するDSCファイルのリスト
     * @return 読み込み済みの全てのファイルリスト
     * @throws IOException
     * @throws InvalidDataFormatException 
     */
    public File[] addDscFile(File[] addFileList) throws IOException, InvalidDataFormatException;
    
    /**
     * 
     * <p>現在読み込まれているファイルリストを初期化します。</p>
     * <p></p>
     * @return retStatus
     */
    public boolean clearFileList();
    
    /**
     * <p>使用する検索アルゴリズムを変更します。</p>
     * @param type アルゴリズムのType現在はTYPE_NORMALのみ。
     * @return アルゴリズムを変更した結果のSearcherをIDocumentSearcher形式で返します。
     */
    public IDocumentSearcher switchSeacher(int type);
    
    /**
     * <p>queryに指定された領域の解釈結果をQueryRect形式で返します。</p>
     * <h3>解説</h3>
     * <p>queryに指定された領域は、実際にはそのまま長方形の形で検索が行われるのではなく、
     * DocumentSearchクラスによって内部表現に変換されてから検索が実行されます。
     * ユーザーが指定したquery領域の形状によっては、ユーザーの意図と内部表現変換結果が異なるかもしれません。
     * 従って内部表現による検索範囲領域とユーザーの意図が合致しているかを確認するため、
     * 検索を実行する前にrectConfirmメソッドを用いて目視による確認を行うことが推奨されます。
     * </p>
     * 
     * @param queryRect query
     * @return 検索対象の領域をQueryRect形式で返します。
     */
    public QueryRect rectConfirm(QueryRect queryRect);
    
    /**
     * <p>DSCデータを読み込んでいるかを返します。</p>
     * 
     * @return flag
     */
    public boolean hasDscData();
        
    /**
     * <p>queryに指定された領域をクエリとして検索を実行します。</p>
     * <p>queryに指定された領域をクエリとして検索を実行し、検索結果の順位付きリストをResultRect形式で返します。</p>
     * @param query
     * @return ResultRect形式で結果を返します。
     */
    public ResultRects search(QueryRect query);
    
    /**
     * <p>このインスタンスのSearcherTypeを返します。</p>
     * @return
     */
    public int getSearcherType();
    
    public void setMaxFound(int maxFound);
}
