/* $Id: RWPackage.java 1072 2016-02-27 04:27:27Z shayashi $ */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;
import smart_gs.GSVersion;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.URIBearer;

public class RWPackage implements RWElement {
	
	protected List<RWElement> elements;
	protected String name ="";
	protected String source = "<xml></xml>";
	protected String uri;
	protected String originalURI;
	protected String oldVersionURI;
	protected String version;
	
	public RWPackage(String uri, String originalURI, String version){
		this.elements = new ArrayList<RWElement>();
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}
	public RWPackage() {
		this.elements = new ArrayList<RWElement>();
		this.initializeURIs();
		this.setVersion(GSVersion.getVersion());
	}
	public void setName(String name){
		this.name = name;
	}
	public String getName() {
		return name;
	}
	public void add(RWElement element){
		this.elements.add(element);
	}
	public void add(List<RWElement> elements){
		this.elements.addAll(elements);
	}

	public List<RWElement> getElements(){
		return this.elements;
	}


	public String getSource() throws NotMarkupException {
		return source;
	}
	public void setSource(String source) {
		this.source = source;
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getURI() {
		return this.uri;
	}
	@Override
	public String getTypeString() {
		return URICreator.RWPACKAGE;
	}
	@Override
	public String getOriginalURI() {
		return this.originalURI;
	}
	@Override
	public void setOriginalURI(String originalURI) {
		this.originalURI = originalURI;
		
	}
	@Override
	public void setURI(String uri) {
		this.uri = uri;
	}
	@Override
	public void setURIs(String uri, String originalURI) {
		URICreator.setURIs(this, uri, originalURI);
	}
	@Override
	public void initializeURIs() {
		this.originalURI = URICreator.createURI(this);
		this.uri = this.originalURI;
	}
	@Override
	public String getVersion() {
		return this.version;
	}
	@Override
	public void setVersion(String version) {
		this.version = version;
	}
	@Override
	public String getOldVersionURI() {
		return this.oldVersionURI;
	}
	@Override
	public void setOldVersionURI(String oldVersionURI) {
		this.oldVersionURI = oldVersionURI;		
	}
}
//oldVersionURI
