package smart_gs.diff;

import java.util.Arrays;
import java.util.List;
import difflib.DiffRow;
import difflib.DiffRowGenerator;



public class ResourceDiff {
	
	private String name;
	private Type type;
	private State state;
	private String diffHtml;
	private boolean changed;
	
	public static enum Type {
        DIRECTORY, SPREAD, SPREAD_DOCUMENT;
    } 
	public static enum State {
        EQUAL, INSERT, DELETE, CHANGE;
    } 
	
	public ResourceDiff(String name, Type type) {
		this.name = name;
		this.setType(type);
		this.diffHtml = "";
		this.changed = false;
				
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public String toString(){
		if (this.changed) {
			return ">" + this.name;
		}
		return this.name;
	}

	public static void main(String[] args) {
		String original = "$0$ 　○老女死期に紀念を託す條<br>$1$ こゝに哀れをとゞめしハ。深川冨川町の辺とかや。柏屋の何某なる者。以<br>$2$ 前ハ有徳に暮しゝが。薄命のうち続き。今ハ次第に困窮して召仕<br>$3$ にも暇をとらせ。たゞ夫婦さし対ひにて。いと淋しく送りけるが十月三日<br>$4$ ハ過さりし。母の年忌にあたるにより。心ばかりの佛事をいとなミ。親き<br>$5$ 人にも供養せん。と同二日ハ逮夜とて。朝まだきより野菜を調へ。米<br>$6$ なンど炊くをりから。僅一二町を隔だてし所に。大工何某なるものゝ<br>$7$ 娘。二十ばかりになりけるが。日来親しく往かふにより。今日の佛事の手<br>$8$ 傅ひせんとて。この家に来りツヽ。いと甲斐〴〵しく働きて。夫婦が手をぞ<br>$9$ 助けける。かくて其夜戌時頃。その事も大かた果て。娘ハ帰らんといひけるを。<br>$10$ 柏屋夫婦ハこれを止め。はや亥刻にも程近からんに。今宵ハ泊りて<br><br>$11$ 翌の朝。とく帰られよといふほどに。その意に任して逗りツヽ。猶とりちら<br>$12$ せし調度など推かたづけて亥刻もうちぬ。はや憩んと床なンど。敷ん<br>$13$ としたるその折から。暴に虚空動揺なし。その家将に覆らんとす。三<br>$14$ 人ハ大に駭きて。表の戸を引開て。矢庭に走り出けるが。柏屋の檐倒<br>$15$ れて。大道へ横たハる。今少し遅からバこの檐に打れツヽ。身を傷んを<br>$16$ 危ふかりしと吐息吻て跪ミ居る。かの娘ハこれを見て。父母の身の<br>$17$ うへ心許なし。暇まうすといひも敢ず。一散に駈出す。夫婦ハ呼び止め<br>$18$ 尤なり。今諸共に行て訪ん。霎時待ねといひけれど。聞えしやまた<br>$19$ 聞えずや。回答もせずして走りゆけバ。柏屋ハ妻に向ひ。日来よりし<br>$20$ て孝心の世に勝れたるものなれバ。心裡然もあるべし。程近けれど<br>$21$ 夜更たり一人やハ帰されじ。我ハ跡より逐着て彼家へ送り達(とどけ)ん";
		String revised = "$0$ 　○老女死期に紀念を託す條<br>$1$ こゝに哀れをとゞめしハ。深川冨川町の辺とかや。柏屋の何某なる者。以<br>$2$ 前ハ有徳に暮しゝが。薄命のうち続き。今ハ次第に困窮して召仕<br>$3$ にも暇をとらせ。たゞ夫婦さし対ひにて。いと淋しく送りけるが十月三日<br>$4$ ハ過さりし。母の年忌にあたるにより。心ばかりの佛事をいとなミ。親き<br>$8$ 傅ひせんとて。この家に来りツヽ。いと甲斐〴〵しく働きて。夫婦が手をぞ<br>$9$ 助けける。かくて其夜戌時頃。その事も大かた果て。娘ハ帰らんといひけるを。<br>$10$ 柏屋夫婦ハこれを止め。はや亥刻にも程近からんに。今宵ハ泊りて<br><br>$11$ 翌の朝。とく帰られよといふほどに。その意に任して逗りツヽ。猶とりちら<br>$12$ せし調度など推かたづけて亥刻もうちぬ。はや憩んと床なンど。敷ん<br>$13$ としたるその折から。暴に虚空動揺なし。その家将に覆らんとす。三<br>ああああああ<br>ああああああ<br>いいいいいい<br>$14$ 人ハ大に駭きて。表の戸を引開て。矢庭に走り出けるが。柏屋の檐倒<br>$15$ れて。大道へ横たハる。今少し遅からバこの檐に打れツヽ。身を傷んを<br>$16$ 危ふかりしと吐息吻て跪ミ居る。かあｋｊｄｆぁｋｓｊｄｆヵｓｋｊの娘ハこれを見て。父母の身の<br>$17$ うへ心許なし。暇まうすといひも敢ず。一散に駈出す。夫婦ハ呼び止め<br>$18$ 尤なり。今諸共に行て訪ん。霎時待ねといひけれど。聞えしやまた<br>$19$ 聞えずや。回答もせずして走りゆけバ。柏屋ハ妻に向ひ。日来よりし<br>$20$ て孝心の世に勝れたるものなれバ。心裡然もあるべし。程近けれど<br>$21$ 夜更たり一人やハ帰されじ。我ハ跡より逐着て彼家へ送り達(とどけ)ん";
		List<String> originalList = Arrays.asList(original.split("<br/?>"));
		List<String> revisedList = Arrays.asList(revised.split("<br/?>"));
		
		DiffRowGenerator.Builder builder = new DiffRowGenerator.Builder();
		boolean sideBySide = true;  //default -> inline
		builder.showInlineDiffs(!sideBySide); 
		builder.columnWidth(120);
		DiffRowGenerator dfg = builder.build();
		List<DiffRow> rows = dfg.generateDiffRows( originalList, revisedList);
		// original text
		System.out.println("<table>");
		int count = 1;
		for (DiffRow row : rows) {
			System.out.println("<tr>");
			System.out.print("<td>"+count+"</td>");
			count++;
			String oldLine = row.getOldLine();
			String newLine = row.getNewLine();			
			switch(row.getTag()) {
			case EQUAL: 
				System.out.print("<td>"+oldLine+"</td>");
				System.out.print("<td>"+newLine+"</td>");
				break;
			case CHANGE:
				System.out.print("<td style='background-color: yellow'>"+oldLine+"</td>");
				System.out.print("<td style='background-color: yellow'>"+newLine+"</td>");
				break;
			case DELETE:
				System.out.print("<td style='background-color: skyblue'><del>"+oldLine+"</del></td>");
				System.out.print("<td></td>");				
				break;
			case INSERT:
				System.out.print("<td></td>");
				System.out.print("<td style='background-color: red'>"+newLine+"</td>");
			default:				
				break;	
			}
			System.out.println("</tr>");
		}
		System.out.println("</table>");
	}

	public Type getType() {
		return type;
	}

	public void setType(Type type) {
		this.type = type;
	}

	public State getState() {
		return state;
	}

	public void setState(State state) {
		this.state = state;
	}

	public String getDiffHtml() {
		return diffHtml;
	}

	public void setDiffHtml(String diffHtml) {
		this.diffHtml = diffHtml;
	}

	public boolean isChanged() {
		return changed;
	}

	public void setChanged(boolean changed) {
		this.changed = changed;
	}

}
