package smart_gs.diff.swingui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

import smart_gs.diff.ResourceDiff;

public class DiffViewer extends JFrame {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private TreeModel diffTree;
	private JPanel content;
	private JTree tree;
	private JEditorPane htmlPane;

	public DiffViewer(TreeModel diffTree) throws HeadlessException {
		this.diffTree = diffTree;
		this.buildUI();
	}
	
	private void buildUI () {
		this.setTitle("Compare projects");
		this.setVisible(true);
		this.setSize(800, 600);
	    this.setLocationRelativeTo(null);
	    this.content = new JPanel();
	    this.content.setLayout(new BorderLayout(5,5));
	    Border padding = BorderFactory.createEmptyBorder(10, 10, 10, 10);
	    this.content.setBorder(padding);
	    this.setContentPane(content);
	    this.buildComponents();
	    
	}
	
	private void buildComponents () {
		this.buildTreeView();
	    this.buildHTMLViewer();
	}
	
	private void buildTreeView () {
		tree = new JTree(this.diffTree);
		tree.addTreeSelectionListener(new DiffTreeListener());
		int v = ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED;
	    int h = ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED;
	    JScrollPane jsp = new JScrollPane(tree, v, h);
	    jsp.setPreferredSize(new Dimension(200, 600));
	    this.content.add("West", jsp);
	}
	
	private void buildHTMLViewer () {
		this.htmlPane = new JEditorPane();		
		htmlPane.setSize(new Dimension(500, 600));
		htmlPane.setContentType("text/html");
		htmlPane.setEditable(false);
		int v = ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED;
	    int h = ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED;
	    HTMLEditorKit kit = new HTMLEditorKit();
	    htmlPane.setEditorKit(kit);
	    StyleSheet styleSheet = kit.getStyleSheet();
	    styleSheet.addRule("em {font-weight: bold; background-color: #99EEFF;}");
	    styleSheet.addRule(".delete {font-weight: bold; background-color: #99EEFF;}");
	    styleSheet.addRule(".insert {font-weight: bold; background-color: #99EEFF;}");
	    styleSheet.addRule(".change {border: 1px solid black;}");
	    JScrollPane jsp = new JScrollPane(htmlPane, v, h);
	    jsp.setSize(new Dimension(400,600));	    
	    this.content.add("Center", jsp);
		
	}
	
	private class DiffTreeListener implements TreeSelectionListener {

		@Override
		public void valueChanged(TreeSelectionEvent e) {			
			DefaultMutableTreeNode node = (DefaultMutableTreeNode) tree.getLastSelectedPathComponent();
			if (node == null || !node.isLeaf()) {
				return;
			}
			ResourceDiff diff = (ResourceDiff) node.getUserObject();
			String html = diff.getDiffHtml();
			Document doc = htmlPane.getEditorKit().createDefaultDocument();
			htmlPane.setDocument(doc);
			htmlPane.setText(html);
			System.out.println("diff: "+ html);
		}

		
	}
 
}
