/* $Id: ExLine2D.java 1100 2016-05-05 06:53:11Z shayashi $ */
/*
 * 作成日: 2006/05/28
 *
 */
package smart_gs.drawing_tool;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

/**
 * @author kazuaki kobayashi
 *
 *  
 *  Line2D.Doubleのcontainsメソッドをoverride
*/
public class ExLine2D extends Line2D.Double {
	
	private double criteria = 10.0;
	
	public ExLine2D(Point2D start, Point2D end) {
		super(start,end);
	}

	public ExLine2D(double x1, double y1, double x2, double y2) {
		super(x1,y1,x2,y2);
	}
	
	public ExLine2D(Point2D start,Point2D end,double criteria){
		super(start,end);
		this.criteria = criteria;
	}
	public ExLine2D(double x1, double y1, double x2, double y2,double criteria) {
		super(x1,y1,x2,y2);
		this.criteria = criteria;
	}
	public void setCriteria(double d){
		this.criteria = d;
	}
	public boolean contains(Point2D p) {
		double distance = this.ptSegDist(p);
		if(distance <= criteria){
			return true;
		}
		else{
			return false;
		}
	}
	public String toString() {
		Point2D start = this.getP1();
		Point2D end = this.getP2();
		String s = (int)start.getX()+" : "+(int)start.getY();
		String e = (int)end.getX()+" : "+(int)end.getY();
		return s+"\n"+e;
	}

	public Point2D getStartPoint() {
		return this.getP1();
	}
	
	public Point2D getEndPoint() {
		return this.getP2();
	}

	public ExLine2D deepCopy() {
		ExLine2D copy = new ExLine2D(this.getStartPoint(),this.getEndPoint());
		copy.criteria = this.criteria;
		return copy;
	}

}
