/* $Id: DeleteRegionAction.java 1072 2016-02-27 04:27:27Z shayashi $ */
package smart_gs.drawing_tool.action;


import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.JFrame;

import reasoning_web.logical.RWRepository;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.logical.Region;
import smart_gs.logical.RegionOperation;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.logical.LinkRemover;
import smart_gs.swingui.WorkspaceWindow;

public class DeleteRegionAction{
	
	private List<Region> regions;
	private State state;
	
	private DeleteRegionAction(){
		this.regions = new ArrayList<Region>();
	}
	public DeleteRegionAction(Region region){
		this();
		this.regions.add(region);
	}
	public DeleteRegionAction(Region region, State state){
		this();
		this.regions.add(region);
		this.state = state;
	}
	public DeleteRegionAction(List<Region> regions){
		this();
		this.regions = regions;
	}
	public void execute(){
		if(regions.get(0) != null){
			for(int i=0;i<this.regions.size();i++){
				if(regions.get(i).isProtected().equals(Region.NORMAL)){
					Region region = this.regions.get(i);
					Spread spread = this.regions.get(i).getSpread();
					spread.pushRegionUndoStack(new RegionOperation(RegionOperation.REMOVE, region, region,region.getSpread()));
					region.makeItZombie();
					spread.removeRegion(region);
//					GS_RWRepository.getInstance().deleteResourceFromBaskets(region);
//					GSResourcePointer grp = GS_RWRepository.getInstance().getResourcePointer(region);
//					// TODO 2011.10.19 shayashi 次のバージョンでゾンビを導入する。
//					//if(grp != null) grp.zombify();
//					//それまでは、リンクを消す。
//					if(grp != null) {
//						LinkRemover.removeLinksOf(grp.getURI());
//					}
					State state = DefaultState.getInstance();
				    ImageLabel.setState(state);
				    WorkspaceWindow.setUpdated(true);
				}
				else{
					JOptionPane.showMessageDialog(new JFrame(), "This markup is protected.","Cannot delete",  JOptionPane.INFORMATION_MESSAGE);
				}
			}
			this.regions.clear();
		}
	}
	
}
