/* $Id: BookmarkMode.java 196 2011-06-01 14:45:14Z minao $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.geom.Rectangle2D;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.AnchorView;
import smart_gs.logical.AnchorTextSegment;
import smart_gs.logical.RegionOperation;
import smart_gs.logical.Spread;
import smart_gs.logical.URIObject;
import smart_gs.logical.region.AnchorRegion;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class AnchorMode  extends DrawingModeAdapter {

	private static Mode singleton = new AnchorMode();
	private static AnchorTextSegment anchorTextSegment;

	public static Mode getInstance() {
		return singleton;
	}
	
	public static void setAnchorTextSegment(AnchorTextSegment anchorTextSegment) {
		AnchorMode.anchorTextSegment = anchorTextSegment;
	}
	
	@Override
	public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas){
		super.mouseClicked(e, canvas);
		int x = (int)e.getPoint().getX();
		int y = (int)e.getPoint().getY();
		int w = (int) AnchorView.WIDTH;
		int h = (int) AnchorView.HEIGHT;
		Rectangle2D rectangle = new Rectangle2D.Double(x, y, w, h);
		AnchorRegion region = new AnchorRegion(canvas.getSpread(), rectangle);
		Spread spread = canvas.getSpread();
		spread.pushRegionUndoStack(new RegionOperation(RegionOperation.ADD,region,region,spread));
		canvas.addRegion(region);

		// 2013/03/23 kukita
		// The created region will be automatically selected.
		UniSelectedState.getInstance().changeSelectedRegions(region);

		anchorTextSegment.setAnchorRegion(region);
		anchorTextSegment.extendURIBy(URIObject.SEP4 + URIObject.chopHeader(region.getURI()));
		region.setAnchorTextSegment(anchorTextSegment);
		DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
		new ImageToolBarSetModeByMouseEvent().setMode(e,ImageToolBar.modeNone);
	}
	
	@Override
	public boolean addingMarkup() {
		return true;
	}
}
