package smart_gs.image_search.transcription_tool.swingui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyleContext;

import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.normal.swingui.QueryPanel;
import smart_gs.util.ImageAdjuster;
import sml_editor.logical.LineDirection;

@SuppressWarnings("serial")
public class TranscriptionToolFrame extends JFrame {
	
	private List<SearchResult> results;
	private Image queryImage;
	private LineDirection lineDirection;
	private JTextField transcriptionTextField;
	private JPanel queryPanel;	
	private SearchResultListPanel resultListPanel;
	private JPanel buttonPanel;
	private JButton backButton;
	private JButton nextButton;
	private JButton closeButton;	
	
	
	public TranscriptionToolFrame (Image queryImage,List<SearchResult> results,LineDirection lineDirection) {
		super("Mass Transcription");
		this.results = results;
		this.lineDirection = lineDirection;		
		this.queryImage = ImageAdjuster.adjust(queryImage,this.lineDirection, 100.0);
		this.setLocation(70,120);
		this.setSize(new Dimension(600,850));
		this.setLayout(new BoxLayout(this.getContentPane(), BoxLayout.PAGE_AXIS));
		this.build();
		this.setVisible(true);
		
	}
	
	private void build() {
		this.queryPanel = new QueryPanel(queryImage, this.lineDirection);		
		this.add(queryPanel);
		this.transcriptionTextField = new JTextField();
		this.transcriptionTextField.setBorder(new TitledBorder("Transcribe search results with:"));
		this.transcriptionTextField.setHorizontalAlignment(SwingConstants.LEFT);
		this.transcriptionTextField.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		this.transcriptionTextField.getDocument().addDocumentListener(new DocumentListener(){
		
			public void actionPerformed(DocumentEvent arg0) {
				String text = transcriptionTextField.getText();
				resultListPanel.updateTranscriptionText(text);
			}
			@Override
			public void changedUpdate(DocumentEvent arg0) {
				this.actionPerformed(arg0);
			}

			@Override
			public void insertUpdate(DocumentEvent arg0) {
				this.actionPerformed(arg0);
			}

			@Override
			public void removeUpdate(DocumentEvent arg0) {
				this.actionPerformed(arg0);
			}
		});
		this.add(transcriptionTextField);
		this.resultListPanel = new SearchResultListPanel(queryImage, results, lineDirection, 7, this.results.size());
		updatePageCounter();
		//this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		//this.scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);		
		this.add(resultListPanel);
		this.buttonPanel = new JPanel();
		this.buttonPanel.setSize(600,200);
		this.backButton = new JButton("Back");
		backButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultListPanel.back();
				updatePageCounter();
				validate();
		}
		});
		this.nextButton = new JButton("Next");
		nextButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultListPanel.next();
				updatePageCounter();
				validate();
		}
		});
		this.closeButton = new JButton("Close");
		this.closeButton.addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent arg0) {
					dispose();
			}
		});		
		buttonPanel.add(backButton);
		buttonPanel.add(nextButton);
		buttonPanel.add(closeButton);		
		this.add(buttonPanel);		
	}
	
	private void updatePageCounter() {
		int page = this.resultListPanel.getPage();
		this.resultListPanel.setBorder(new TitledBorder("Search results and suggested transcriptions  (Page " + page + ")"));
	}

}
