/* $Id: ToolMenu.java 1064 2016-01-24 16:02:47Z shayashi $ */
package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.GSConstants;
import smart_gs.PreferenceManager;
import smart_gs.dictionary.DictionaryDialog;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.CloseUpRectangleMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.DeleteMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.image_search.normal.swingui.TranscriptionToolNo1Frame;
import smart_gs.logical.GSResource;
import smart_gs.logical.Preference;
import smart_gs.logical.ResourceBasket;
import smart_gs.logical.Region;
import smart_gs.logical.Sheet;
import smart_gs.logical.SpreadTree;
import smart_gs.menu.action.ResourceListAction;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.ResourceBasketsFrame;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.action.CompareActionListener;
import smart_gs.transcription_tool.TranscriptionDialog;
import smart_gs.transcription_tool.TranscriptionToolFrame;

/**
 * 2007/11/1 kazuhiro kobayashi
 * @author Administrator
 *
 */
public class ToolMenu extends JMenu implements ActionListener {

	private JMenuItem select;
	private JMenuItem deleter;
	private JMenuItem rectangle;
	private JMenuItem marker;
	private JMenuItem polygon;
	private JMenuItem memopad;
	private JMenuItem bookmark0;
	private JMenuItem closeUp;
	private JMenuItem tmprectangle;
	private JMenuItem tmpmarker;
	private JMenuItem tmppolygon;
	private JMenuItem tmpbookmark;
	private JMenuItem resourceBasket;
	private JMenuItem reasoningWeb;

	private JMenuItem zoomIn;
	private JMenuItem zoomOut;
	private JMenuItem fullSize;
	private JMenuItem fitWidth;
	private JMenuItem fitHeight;
	private JMenu showRegion;
	private AbstractGSWindow parent;
	private JMenuItem allRegions;
	private JMenuItem protectedRegions;
	private JMenuItem noRegions;
	private JMenuItem protectAllRegions;
	private JMenuItem releaseAllRegions;
	private JMenuItem compare;

	public ToolMenu(String title, AbstractGSWindow parent) {
		super(title);
		this.parent = parent;

		
		JMenuItem dictionary = new JMenuItem("Dictionary");
		dictionary.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DictionaryDialog dictionaryDialog = new DictionaryDialog(WorkspaceWindow.getInstance(),"Dictionary",false,0);
				dictionaryDialog.setVisible(true);
			}
		});
		this.add(dictionary);
		
		this.addSeparator();
		this.compare = new JMenuItem("Compare");
		this.compare.addActionListener(new CompareActionListener());
		this.add(this.compare);
	}

	public void actionPerformed(ActionEvent e) {
		ImageToolBar imagetoolbar = WorkspaceWindow.getInstance().getImageToolBar();
		if (e.getSource().equals(this.allRegions)) {
			imagetoolbar.setShowRegionItem(ImageToolBar.showAll);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_ALL_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.protectedRegions)) {
			imagetoolbar.setShowRegionItem(ImageToolBar.showProtected);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_PROTECTED_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.noRegions)) {
			imagetoolbar.setShowRegionItem(ImageToolBar.showNo);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_NO_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.protectAllRegions)) {
			parent.getSpreadCanvas().protectAllRegions();
		} else if (e.getSource().equals(this.releaseAllRegions)) {
			parent.getSpreadCanvas().releaseAllRegions();
		} 
	}
}