/* $Id: GSConnection.java 1080 2016-03-30 00:49:23Z minao $ */
package smart_gs.reasoning_web.logical;

import javax.swing.JLabel;
import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.connection.lastConnectionToConfirmAndEditFrame;

import smart_gs.logical.GSResource;
import smart_gs.logical.URIObject;
import smart_gs.reasoning_web.swingui.view.ConnectionView;
import smart_gs.reasoning_web.swingui.view.View;

public class GSConnection extends Connection implements GS_RWElement {

	protected View view;

	public GSConnection(GSResourcePointer source, GSResourcePointer target,
			ExplanatoryNote note, String uri, String originalURI,
			String version) {
		super(source, target, note, uri, originalURI, version);
		this.view = new ConnectionView(this);

		// 2007/11/12 kazuhiro kobayashi
//		ExpNoteManager.getInstance().addNote((GSExplanatoryNote) this.expNote);
	}

	public GSConnection(GSResourcePointer source, GSResourcePointer target,
			ExplanatoryNote note) {
		super(source, target, note);
		this.view = new ConnectionView(this);
	}

	
	
	public View getView() {
		return this.view;
	}
// TODO 表示できないものの表示を統一せよ！！
	public JPanel createElementViewPanel() throws NoWayToShowException {
		try {
			return ((GSExplanatoryNote) this.expNote).createElementViewPanel();
		} catch (NoWayToShowException e) {
			throw e;
		}
	}
	public JPanel createElementViewPanel(int width,int height) throws NoWayToShowException {
		JPanel panel = new JPanel();
		panel.add(new JLabel("Connection"));
		panel.setSize(width, height);
		return panel;
	}

	@Override
	public GSResourcePointer getSourcePointer() {
		return (GSResourcePointer) super.getSourcePointer();
	}
	
	@Override
	public GSResourcePointer getTargetPointer() {
		return (GSResourcePointer) super.getTargetPointer();
	}

	public void show() {
		lastConnectionToConfirmAndEditFrame tmp = new lastConnectionToConfirmAndEditFrame(this, "Chosen Connection");
		tmp.setCancelDisabled();
		tmp.setVisible(true);;
	}

//	public String getURI() {
//		return this.uri;
//	}

	public Element createXMLElement(Document document) {
		Element element = document.createElement("connection");
		element.setAttribute("uri", this.uri);
		element.setAttribute(GSResource.ORIGINAL_URI, this.originalURI);
		element.setAttribute(GSResource.OLD_VERSION_URI, this.getOldVersionURI());
		element.setAttribute(GSResource.VERSION, this.version);
		element.setAttribute("name", this.name);
		Element sourceElem = ((GSResourcePointer) this.source)
				.createXMLElement(document);
		sourceElem.setAttribute("type", "source");
		element.appendChild(sourceElem);
		Element targetElem = ((GSResourcePointer) this.target)
				.createXMLElement(document);
		targetElem.setAttribute("type", "target");
		element.appendChild(targetElem);
		element.appendChild(((GSExplanatoryNote) this.expNote)
				.createXMLElement(document));
		return element;
	}

	public static GSConnection restore(Element element) {
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String oldVersionURI = element.getAttribute(GSResource.OLD_VERSION_URI);
		String version = element.getAttribute(GSResource.VERSION);
		String name = element.getAttribute("name");

		GSResourcePointer source = null;
		GSResourcePointer target = null;
		NodeList list = element.getElementsByTagName("pointer");
		Element elem1 = (Element) list.item(0);
		String type = elem1.getAttribute("type");
		if (type.equals("source")) {
			source = GSResourcePointer.restore(elem1);
		} else {
			target = GSResourcePointer.restore(elem1);
		}
		Element elem2 = (Element) list.item(1);
		String type2 = elem2.getAttribute("type");
		if (type2.equals("source")) {
			source = GSResourcePointer.restore(elem2);
		} else {
			target = GSResourcePointer.restore(elem2);
		}

		Element noteElement = (Element) element.getElementsByTagName(
				"explanatory").item(0);

		GSExplanatoryNote note = GSExplanatoryNote.restore(noteElement);
		ExpNoteManager.getInstance().addNote(note);
		GSConnection connection = new GSConnection(source, target, note,
				uri, originalURI, version);
		connection.setOldVersionURI(oldVersionURI);
		connection.setVersion(version);
		connection.setName(name);
		return connection;
	}

	public String getDate() {
		return URIObject.getDateFrom(this.uri);
	}

	public String getUserName() {
		return URIObject.getConnectionUsersNameFrom(this.uri);
	}
}
