/* $Id: GSResourcePointer.java 1084 2016-04-01 16:13:47Z shayashi $ */
package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import java.util.Hashtable;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.ResourcePointer;

import smart_gs.logical.GSResource;
import smart_gs.logical.URISolver;
import smart_gs.logical.ZombieGSResourceForRestoring;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.view.ResourcePointerView;
import smart_gs.reasoning_web.swingui.view.View;
import smart_gs.util.GSLog;
import smart_gs.util.Quadruple;

public class GSResourcePointer extends ResourcePointer {

	protected View view;

//	Any GS_RWElement has an unique GSResourcePointer. See RWRepository.java. 
	public GSResourcePointer(int x, int y, GSResource element) {
		super(element);
		this.view = new ResourcePointerView(x, y, this);
	}
	
//	Any GS_RWElement has an unique GSResourcePointer. See RWRepository.java. 
	public GSResourcePointer(GSResource element) {
		super(element);
		this.view = new ResourcePointerView(this);
	}

	public GSResourcePointer(String uri, String original_uri) {
		super(uri,original_uri);
		this.view = new ResourcePointerView(this);
	}

	public View getView() {
		return this.view;
	}
	
	public ArrayList<Quadruple<Connection,GSResourcePointer, GSExplanatoryNote, Integer>> getLocalViewInfo() {
		ArrayList<Quadruple<Connection, GSResourcePointer, GSExplanatoryNote, Integer>> elements = 
			new ArrayList<Quadruple<Connection, GSResourcePointer, GSExplanatoryNote, Integer>>();
		for (int i = 0; i < this.connections.size(); i++) {
			Connection connection = this.connections.get(i);
			ExplanatoryNote note = connection.getExplanatoryNote();
			int this_edge_type = connection.typeOfPointerInConnection(this);
			int peer_edge_type;
			GSResourcePointer peer_pointer;
			if (this_edge_type == Connection.SOURCE) {
				peer_pointer = connection.getTargetPointer();
				peer_edge_type = Connection.TARGET;
			} else if (this_edge_type == Connection.TARGET) {
				peer_pointer = connection.getSourcePointer();
				peer_edge_type = Connection.SOURCE;
			} else {
				// the edges are identical. 
				peer_pointer = connection.getTargetPointer();
				peer_edge_type = Connection.LOOP;
			}
			elements.add(
					new Quadruple<Connection,GSResourcePointer, GSExplanatoryNote, Integer> (
							connection,
							peer_pointer,
							(GSExplanatoryNote) note,
							new Integer(peer_edge_type)
					)
			);
		}
		return elements;
	}

	public Element createXMLElement(Document document) {
		Element element = document.createElement("pointer");
		
		String originalURI, uri;
		if (this.isZombieByRestore()) {
			 uri = this.getZombieURI();
			 originalURI = this.getZombieOriginalURI();
		} else {
			 uri = ((GS_RWElement) this.resource).getURI();
			 originalURI = ((URIBearer) this.resource).getOriginalURI();
		}
		element.setAttribute(GSResource.URI,uri);
		element.setAttribute(GSResource.ORIGINAL_URI,originalURI);
		
		element.setAttribute("x", String.valueOf(this.view.getRectangle()
				.getX()));
		element.setAttribute("y", String.valueOf(this.view.getRectangle()
				.getY()));
		element.setAttribute("width", String.valueOf(this.view.getRectangle()
				.getWidth()));
		element.setAttribute("height", String.valueOf(this.view.getRectangle()
				.getHeight()));

		// 2007/10/23
		if (this.name != "") {
			element.setAttribute(GSResource.NAME, this.name);
		}

		return element;
	}

	public static GSResourcePointer restore(Element element) {
		String original_uri = element.getAttribute("originalURI");
		String uri = element.getAttribute("uri");

		double x = 300;
		double y = 300;
		//
		String name = "";
		if (element.getAttribute("x") != "") {
			x = Double.parseDouble(element.getAttribute("x"));
		}
		if (element.getAttribute("y") != "") {
			y = Double.parseDouble(element.getAttribute("y"));
		}
		if (element.getAttribute(GSResource.NAME) != "") {
			name = element.getAttribute(GSResource.NAME);
		}
		//
		GSResource resource = URISolver.getResource(uri);
		if (resource == null) {
			return new GSResourcePointer(uri, original_uri);
		}
		if (GS_RWRepository.getInstance().isRegistered(resource)) {
			// 2007/10/22 kazuhiro kobayashi
			GSResourcePointer pointer = GS_RWRepository.getInstance()
					.getResourcePointer(resource);
			pointer.view.setRectangle(x, y);
			// 10/23
			pointer.setName(name);
			// pointer.setNote(note);
			//
			return pointer;
		}

		GSResourcePointer pointer = new GSResourcePointer((int) x, (int)y, resource);
		pointer.setName(name);
		return pointer;
	}

	public String getURI() {
		if (this.isZombified()) return this.getZombieURI() ;
		return this.resource.getURI();
	}


}
