/* $Id: ConnectionViewPanel.java 1080 2016-03-30 00:49:23Z minao $ */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.reasoning_web.logical.GS_RWRepository;

@SuppressWarnings("serial")
public class ConnectionViewPanel extends JPanel {

	private JScrollPane elementViewPanel;
	private RWElementsPanel elementsPanel;
	private JScrollPane scrollPane;
	private JToolBar toolBar;

	

	public ConnectionViewPanel() {
		this.toolBar = new RWToolbar();
		this.elementViewPanel = new JScrollPane();
		this.elementsPanel = new RWElementsPanel();
		// elementspanelとGrobalViewPanelの間でelementを関連付けさせる。
		GS_RWRepository.getInstance().addObserver(this.elementsPanel);

		// Left hand side Panel
		this.elementViewPanel.setViewportView(elementsPanel);

		// Pane,Panelの構成
		JScrollPane leftMarkupsListPane = new JScrollPane(this.elementViewPanel);
		this.scrollPane = new JScrollPane();
		this.scrollPane
				.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		this.scrollPane
				.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		this.scrollPane.getVerticalScrollBar().setUnitIncrement(25);
		
		// Right hand side Panel
		this.scrollPane.setViewportView(RWGlobalViewPanel.getInstance());
		
		
		JPanel mPanel = new JPanel(new BorderLayout());
		mPanel.add(this.scrollPane, BorderLayout.CENTER);
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
				true, leftMarkupsListPane, mPanel);
		splitPane.setOneTouchExpandable(true);
		splitPane.setDividerLocation(500);

		this.setLayout(new BorderLayout());
		this.add(splitPane, BorderLayout.CENTER);

	}

	/*
	 * 以下のメソッドはReasoningWebFrameから呼び出される
	 */
	public JToolBar getToolBar() {
		return this.toolBar;
	}

	public RWElementsPanel getElementsPanel() {

		return elementsPanel;
	}

	public void reload() {
		this.elementsPanel.reload();
	}

	public ResourceTable getMarkupTable() {
		return this.elementsPanel.getMarkupTable();
	}

	public ResourceTable getConnectionTable() {
		return this.elementsPanel.getConnectionTable();
	}

}
