package smart_gs.reasoning_web.swingui;

import java.util.ArrayList;

import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

import reasoning_web.logical.Connection;
import smart_gs.debugprint.Debugprint;
import smart_gs.logical.GSResource;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.ConnectionTable.ConnectionTableListSelectionListener;
import smart_gs.reasoning_web.swingui.view.View;

public class MarkupTable extends ResourceTable {
	
	private ConnectionTable connectionTable;

	public MarkupTable(ResourceTableModel model) {
		super(model);
		this.getSelectionModel().addListSelectionListener(new MarkupTableListSelectionListener(this));

	}
	
	public ConnectionTable getConnectionTable() {
		return connectionTable;
	}
	public void setConnectionTable(ConnectionTable connectionTable) {
		this.connectionTable = connectionTable;
	}


	class MarkupTableListSelectionListener implements ListSelectionListener {
		 
		private MarkupTable table;
		
		MarkupTableListSelectionListener(MarkupTable table) {
			this.table = table;
		}

		@Override
		public void valueChanged(ListSelectionEvent arg0) {
			int index = this.table.getSelectedResourceIndex();
			if (index < 0) return;
			ArrayList<GSResource> markups = this.table.getResourceTableModel().getMarkups();
			GSResource element = markups.get(index);
			if(element == null){
				return;
			}
			View.clearSelection();
			if(GS_RWRepository.getInstance().getResourcePointer((GS_RWElement)element) != null){
				GS_RWRepository.getInstance().getResourcePointer((GS_RWElement)element)
					.getView().setIsSelected(true);
			}
			connectionTable.clearSelection();
			this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
			ReasoningWebFrame.getInstance().repaint();
			
		}
	}


	public void setSelectedElement(GSResource element) {
		int index = ((ResourceTableModel)this.getModel()).getIndex(element);
		if (index < 0) return;
		this.setRowSelectionInterval(index, index);
	}

}