package smart_gs.reasoning_web.swingui;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import smart_gs.logical.region.AnchorRegion;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.logical.region.MarkerRegion;
import smart_gs.logical.region.MemoPadRegion;
import smart_gs.logical.region.PolygonRegion;
import smart_gs.logical.region.RectangleRegion;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.util.GSLog;

public class RWElementPanelJListCellRenderer implements ListCellRenderer {
	  private static final long serialVersionUID = 1L;
	  
	  @Override
	  public Component getListCellRendererComponent(
			  JList list, Object object,int index, 
			  boolean isSelected, boolean hasFocus) {
		  String uri, sort;
		  String sep = "  ";
		  Boolean visible;
		  GS_RWElement elm;
		  if (! (object instanceof GS_RWElement)) return new JLabel("Invalid element at index " + index);
		  elm = (GS_RWElement) object;
		  uri = elm.getURI();
		  if (uri.contains("\\")) {
			  GSLog.getInstance().warn("Backslash exsits in uri:" + uri);
//			  return null;
		  }
		  uri = uri.replaceFirst("smart://", "");
		  String [] splited = uri.split("/");
		  sort = splited[0];
		  JLabel label = null;
		  if (sort.equals("connection")) {
			  String name = splited[1];
			  String username = splited[2];
			  String creation_time = splited[3];
			  label = new JLabel(sort + sep + name + sep + username + sep + creation_time);
		  } else {
			  if (sort.equals("rect")) sort = "rectangle"; 
			  String username = splited[1];
			  String creation_time = splited[2];
			  label = new JLabel(sort + sep + username + sep + creation_time);
		  }
		  
		  label.setOpaque(true);
		  
		  if (isSelected){
			  label.setBackground(new Color(255,80,80));
		  } else {
			  label.setBackground(new Color(255,255,255));
		  }
		  return label;
	  }
}
