package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

import smart_gs.GSConstants;
import smart_gs.util.GSLog;

public class ZombiePanel {

	public static JPanel getZombieElementViewPanelForLocalView(String zombie_url) {
		Image image=null;

		try {
			image = ImageIO.read(new File("./icons/zombie.png"));
		} catch (IOException e) {
			GSLog.getInstance().error("Failed to read Zombie image.");
			JPanel panel = new JPanel();
			int width = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;
			int height = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;
			panel.setPreferredSize(new Dimension(width, height));
			panel.setBackground(Color.BLUE);
			return panel;
		}

		JLabel label = new JLabel();
		label.setHorizontalAlignment(JLabel.CENTER);
		ImageIcon icon = new ImageIcon(image);
		label.setIcon(icon);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.add(label,BorderLayout.CENTER);
		panel.addMouseListener(new ZombiePanelListener(zombie_url,panel));
		return panel;
	}
	
	

}
