package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.TimeZone;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

import smart_gs.GSConstants;
import smart_gs.debugprint.Debugprint;
import smart_gs.logical.FirstIDAT;
import smart_gs.logical.IDAT;
import smart_gs.logical.Region;
import smart_gs.logical.SecondIDAT;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.logical.URIObject;
import smart_gs.logical.UsersNote;
import smart_gs.logical.ZombieGSResourceForRestoring;
import smart_gs.menu.action.SpreadJumpAction;
import smart_gs.menu.action.SpreadOpenAction;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.swingui.WorkspaceWindow;

public class ZombiePanelListener extends MouseAdapter {
	private String url;
	private JPanel panelOfLocalView;
	private JWindow window;
	private JPanel panelToDisplayInformation = new JPanel();

	public ZombiePanelListener(String string, JPanel panel) {
		this.url = string;
		this.panelOfLocalView = panel;
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		//NOP
	}
	
	@Override
	public void mouseEntered(MouseEvent e) {
		super.mouseEntered(e);
		
		String[] token = (this.url.substring(8)).split("\\^");
		TimeZone timeZone = TimeZone.getDefault();

		String toPrint = new String();
		
		String[] token0 = token[0].split("/");

		String kind = token0[0];
		String userName = token0[1];
		String creationTime = URIObject.localizeDate(timeZone, token0[2]) 
				+ " ("+ timeZone.getID() +")";
		
		String locationName;
		String locationKind;
		String locationPath;
		
		if (kind.equals("segment")) {
			kind = "Text Segment";
			String[] token1 = token[1].split("/");
			locationKind = token1[0];
			
			if (locationKind.equals("usersNote")) {
				locationKind = "Users' Note";
			} else if (locationKind.equals("firstIdat")) {
				locationKind = "first IDAT";
			} else if (locationKind.equals("secondIdat")) {
				locationKind = "second IDAT";
			} else if (locationKind.equals("thirdIdat")) {
				locationKind = "third IDAT";
			}
		
			if (locationKind.equals("Users' Note")) {
				locationName = token1[1];
				String[] token2 = token[2].split("/");
				int length = token2.length;
				locationPath = new String();
				for (int i = 1;i<length-2;i++) {
					locationPath += "/" + token2[i];
				}
				toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>Note Name: %s<br>Path: %s<br></html>",
						kind,userName,creationTime,locationKind,locationName,locationPath);
			} else {
				String[] token2 = token[2].split("/");
				locationName = token2[1];
				locationPath = new String();
				String[] token3 = token[3].split("/");
				int length = token3.length;
				for (int i = 1;i<length;i++) {
					locationPath += "/" + token3[i];
				}
				locationPath += "/" + locationName;
				toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>Spread Name: %s<br>Path: %s<br></html>",
						kind,userName,creationTime,locationKind,locationName,locationPath);
			}

		} else {
			locationKind = "Image";
			if (kind.equals("rect")) {
				kind = "Rectangle";
			} else if (kind.equals("marker")) {
				kind = "Marker";
			} else if (kind.equals("polygon")) {
				kind = "Polygon";
			} else if (kind.equals("memopad")) {
				kind = "MemoPad";
			} else if (kind.equals("bookmark")) {
				kind = "Bookmark";
			}	
			String[] token1 = token[1].split("/");
			locationName = token1[1];
			locationPath = new String();
			String[] token2 = token[2].split("/");
			int length = token2.length;
			for (int i = 1;i<length;i++) {
				locationPath += "/" + token2[i];
			}
			locationPath += "/" + locationName;
			toPrint = String.format("<html>Kind: %s<br>User: %s<br>Time: %s<br>Location Kind: %s<br>Spread Name: %s<br>Path: %s<br></html>",
					kind,userName,creationTime,locationKind,locationName,locationPath);
		}

		JLabel label = new JLabel(toPrint);
		
		panelToDisplayInformation.add(label,BorderLayout.CENTER);
		
		if (window == null) window = new JWindow();
		
		window.getContentPane().setLayout(new BorderLayout());
		window.getContentPane().add(label,BorderLayout.CENTER);

		Point orig_p = panelOfLocalView.getLocationOnScreen();
		Point p = new Point(orig_p.x + GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE + 10, orig_p.y);
		window.setLocation(p);

		window.pack();
		window.setVisible(true);
	}
	
	@Override
	public void mouseExited(MouseEvent e) {
		if(this.window != null){
			this.window.setVisible(false);
		}
	}
	

	
}
