package smart_gs.smleditor.swingui;

import java.awt.Image;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

import smart_gs.GSConstants;

public class LineSegEditorToolBar extends JToolBar {
	
	LineSegEditor editor;
	JButton select;
	JButton auto;
	JButton divide;
	JButton vertexed;
	JButton rect;
	JButton polygon;
	JButton change_indexes;
	JButton delete;
	JButton info;

	public LineSegEditorToolBar(LineSegEditor parent) {
		this.editor = parent;		
		
		select = new JButton(new ImageIcon(GSConstants.ICON_PATH+"select.gif"));
		select.addActionListener(this.editor.lsgEditor_select);
		select.setToolTipText("Select");
		add(select);
		
		JButton undo = new JButton(new ImageIcon(GSConstants.ICON_PATH+"undo.gif"));
		undo.addActionListener(this.editor.lsgEditor_undo);
		undo.setToolTipText("Undo");
		add(undo);
		
		JButton redo = new JButton(new ImageIcon(GSConstants.ICON_PATH+"redo.gif"));
		redo.addActionListener(this.editor.lsgEditor_redo);
		redo.setToolTipText("Redo");
		add(redo);
		
		auto = new JButton(new ImageIcon(GSConstants.ICON_PATH+"auto.png"));
		auto.addActionListener(this.editor.lsgEditor_autoDrawRectangles);
		auto.setToolTipText("Auto");
		add(auto);
		
		divide = new JButton(new ImageIcon(GSConstants.ICON_PATH+"cutsegment.png"));
		divide.addActionListener(this.editor.lsgEditor_divide);
		divide.setToolTipText("Divide");
		add(divide);
		
		vertexed = new JButton(new ImageIcon(GSConstants.ICON_PATH+"vertexed.png"));
		vertexed.addActionListener(this.editor.lsgEditor_editVertex);
		vertexed.setToolTipText("Edit Vertexes");
		vertexed.setEnabled(false);
		add(vertexed);

		
		rect = new JButton(new ImageIcon(GSConstants.ICON_PATH+"rectangle.png"));
		rect.addActionListener(this.editor.lsgEditor_drawRectangle);
		rect.setToolTipText("Rectangle");
		add(rect);

		polygon = new JButton(new ImageIcon(GSConstants.ICON_PATH+"polygon.png"));
		polygon.addActionListener(this.editor.lsgEditor_drawPolygon);
		polygon.setToolTipText("Polygon");
		add(polygon);

		JButton zoomin = new JButton(new ImageIcon(GSConstants.ICON_PATH+"zoom_in.gif"));
		zoomin.addActionListener(this.editor.lsgEditor_zoomIn);
		zoomin.setToolTipText("Zoom In");
		add(zoomin);

		JButton zoomout = new JButton(new ImageIcon(GSConstants.ICON_PATH+"zoom_out.gif"));
		zoomout.addActionListener(this.editor.lsgEditor_zoomOut);
		zoomout.setToolTipText("Zoom Out");
		add(zoomout);
		
		change_indexes = new JButton(new ImageIcon(GSConstants.ICON_PATH+"changeindex.png"));
		change_indexes.addActionListener(this.editor.lsgEditor_changeIndex);
		change_indexes.setToolTipText("Change Indexes");
		add(change_indexes);
		
		delete = new JButton(new ImageIcon(GSConstants.ICON_PATH+"delete.png"));
		delete.addActionListener(this.editor.lsgEditor_delete);
		delete.setToolTipText("Delete Lines");
		add(delete);
		
		info = new JButton(new ImageIcon(GSConstants.ICON_PATH+"info.png"));
		info.addActionListener(this.editor.lsgEditor_info);
		info.setToolTipText("info Lines");
		add(info);
		
	}
	
	public void  resetButtons () {
		select.setEnabled(true);
		auto.setEnabled(true);
		divide.setEnabled(true);
//		vertexed.setEnabled(true);
		rect.setEnabled(true);
		polygon.setEnabled(true);
		change_indexes.setEnabled(true);
		delete.setEnabled(true);
	}
	public void  disableAutoButton () { auto.setEnabled(false); }
	public void  disableDivideButton () { divide.setEnabled(false); }
	public void  disableVertexedButton () { vertexed.setEnabled(false); }
	public void  disableRectButton () { rect.setEnabled(false); }
	public void  disablePolygonButton () { polygon.setEnabled(false); }
	public void  disableChangeIndexesButton () { change_indexes.setEnabled(false); }
	public void  disableDeleteButton () { delete.setEnabled(false); }
}
