/* $Id: IndexChangeTable.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.spread_selection;

import java.util.Vector;

// indexChangeTable[i] == -1 means that the i-th element is not used.
// When i-th spread in the old indexing is deleted, then indexChangeTable[i] == -1 denotes that 
public class IndexChangeTable {
	int indexChangeTable[];

	public IndexChangeTable(int size) {
		indexChangeTable = new int[size] ;
		for (int i = 0; i< size; i++) indexChangeTable[i] = -1;
	}
	
	public void set(int oldIndex, int newIndex) {
		this.indexChangeTable[oldIndex] = newIndex;
	}
	
	public int get(int oldIndex) {
		return indexChangeTable[oldIndex];
	}
	
	public int size() {
		return indexChangeTable.length;
	}
}
