/* $Id: SearchDialog.java 1064 2016-01-24 16:02:47Z shayashi $ */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import smart_gs.image_search.normal.swingui.ImageSearchPanel;
import smart_gs.logical.Region;
import smart_gs.text_search.swingui.TextSearchPanel;

public class SearchDialog extends JDialog {
	private static final long serialVersionUID = 1L;

	JPanel panel;
	
	public SearchDialog () {
		super(new JFrame(), "Global Text Search");
		SetIcon.setIcon(this);
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);

		panel = new TextSearchPanel();
		
		mainPanel.add(panel);
	}
	
	public SearchDialog (Region region) {
		super(new JFrame(), "Image Search");
		SetIcon.setIcon(this);
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);

		panel = new ImageSearchPanel(region);

		((ImageSearchPanel)panel).setSearchDialog(this);
		
		mainPanel.add(panel);
	}
	


}
