package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class DrawRectangleActionListener implements ActionListener {
	
	private boolean tmpRegion;

	public DrawRectangleActionListener(AbstractGSWindow abstractGSWindow) {
		this.tmpRegion = false;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		Mode mode0 = RectangleMode.getInstance();
		if (WorkspaceWindow.getInstance().onlyOneOfAltCtrlShiftIsPressed()) {
			mode0.setTemporary(true);
			DefaultState.getInstance().setMode(mode0);
		} else {
			mode0.setTemporary(this.tmpRegion);
			DefaultState.getInstance().setMode(mode0);
		}
	}
	
	public DrawRectangleActionListener setTmp(boolean b) {
		this.tmpRegion = b; 
		return this;
	}

}
