/* $Id: GSFileFilter.java 885 2014-09-17 15:19:26Z shayashi $ */
package smart_gs.swingui.toolbar.action;

import java.io.File;

import javax.swing.filechooser.FileFilter;


import smart_gs.util.CanonicalPathString;

public class GSFileFilter extends FileFilter{
	
	private String extension; 
	
	public GSFileFilter() {
		super();
		this.extension = "gsx";
	}
	
	public GSFileFilter(String extension) {
		super();
		this.extension = extension;
	}

	public boolean accept(File pathname) {
		if((CanonicalPathString.get(pathname).endsWith("." + this.extension))) {
			return true;
		} else if(pathname.isDirectory()){
			return true;
		}
		return false;
	}

	@Override
	public String getDescription() {
		return extension;
	}
}
