package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorDrawPolygonMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorSelectMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorSemiAutomaticMode;
import smart_gs.logical.Preference;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.WorkspaceWindow;


public class LineSegEditorActionListener implements ActionListener {

	private WorkspaceWindow parent;
	public LineSegEditorActionListener () {
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		this.parent = WorkspaceWindow.getInstance();
		LineSegEditor editor;
		ImageLabel.setLineVisible(true);
		if (this.parent.getSpread() == null) {
			JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(),"Spread is not chosen","Error",JOptionPane.ERROR_MESSAGE);
			return;
		} else {
			if (this.parent.isLineSegEditorOpen()) return;
			editor = new LineSegEditor(this.parent.getSpread());
			this.parent.setLineSegEditor(editor);
		}

		if (editor.getLineSegEditorImageLabel().isCanceled()){
			this.parent.setLineSegEditor(null);
			return;
		} else {
			editor.setMode(new LineSegEditorSelectMode(editor));
			editor.setVisible(true);
		}
	}
}

