package smart_gs.swingui.toolbar.action;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.LineSegEditorImageLabel;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorRotationMode;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorTiltImagePanelLevelLineMode;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.LineSegEditorMoveAndResizeFrame;
import smart_gs.swingui.LineSegEditorRotationFrame;

public class LineSegEditorRotateActionListener implements ActionListener {
	private LineSegEditor editor;
	private LineSegEditorImageLabel imglabel;
	private int center_x, center_y;
	private Spread spread;

	public LineSegEditorRotateActionListener(LineSegEditor editor) {
		this.editor = editor;
		this.imglabel = editor.getLineSegEditorImageLabel();
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		this.spread = this.editor.getSpread();
		if(ImageLabel.isLineShown()==false){
			JOptionPane.showMessageDialog(new JFrame(), "Please show Lines","error",  JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		if (this.editor.getMode() instanceof LineSegEditorRotationMode) return;
		LineSegEditorRotationFrame frame = new LineSegEditorRotationFrame(this.editor);
		this.editor.setMode(new LineSegEditorRotationMode(this.editor,frame));
		this.editor.setLineSegEditorImageLabelCursor(new Cursor(Cursor.DEFAULT_CURSOR));
		frame.setVisible(true);
	}

}
