package smart_gs.swingui.toolbar.action;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.LineSegEditorRotationFrame;

public class LineSegEditorRotateFrameButtonsActionListener implements
ActionListener {

	private LineSegEditorRotationFrame frame;
	private LineSegEditor editor;
	private Double degree;

	public LineSegEditorRotateFrameButtonsActionListener(LineSegEditor editor, LineSegEditorRotationFrame frame,Double degree) {
		this.frame = frame;
		this.editor = editor;
		this.degree = degree;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		Double centerX = new Double(this.frame.getCenterX());
		Double centerY = new Double(this.frame.getCenterY());
		AffineTransform transformation = new AffineTransform();
		transformation.rotate(Math.cos(this.degree),Math.sin(this.degree),centerX,centerY);
		
		this.editor.pushUndoStack();
		LineSegmentForEdit line = editor.getLinesForEdit().get(0);
		if(line == null){
			JOptionPane.showMessageDialog(new JFrame(), "null","error",  JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		this.editor.rotateLines(transformation);
		this.editor.repaint();
	}
}
