package smart_gs.swingui.toolbar.action;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.smleditor.swingui.LineSegEditor;

public class LineSegEditorUndoRedoActionListener implements ActionListener {
	LineSegEditor editor;
	int type = 0; // 0 is undo 1 is redo.

	public LineSegEditorUndoRedoActionListener(LineSegEditor editor, int type) {
		this.editor = editor;
		this.type = type;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		if (type == 0) {  // undo
			if (!editor.isUndoStackEmpty()) {
				editor.undo();
				editor.rewriteLineSegIndexes();
				this.editor.setLineSegEditorImageLabelCursor(new Cursor(Cursor.DEFAULT_CURSOR));
				editor.invalidate();
				editor.validate();
				editor.repaint();
			}
		}
		
		if (type == 1) {  // redo
			if (!editor.redoStackIsEmpty()) {
				editor.redo();
				editor.rewriteLineSegIndexes();
				this.editor.setLineSegEditorImageLabelCursor(new Cursor(Cursor.DEFAULT_CURSOR));
				editor.invalidate();
				editor.validate();
				editor.repaint();
			}
		}
	}
}
