/* $Id: ReplaceResultViewer.java 709 2013-07-08 02:56:53Z ohura $ */
package smart_gs.text_search.swingui;


import java.awt.*;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyleContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.text_search.SearchTextAction;
import smart_gs.text_search.logical.SearchResult;

@SuppressWarnings("serial")
public class ReplaceResultViewer extends JFrame{

	private JPanel queryPanel;
	private ReplaceResultListPanel resultListPanel;
	private JPanel buttonPanel;
	private JButton backButton;
	private JButton nextButton;
	private final int SIZE_TO_DISPLAY = 10;
	private JButton replaceAllButton;
	private JButton replaceSelectedButton;
	private JCheckBox selectAllThisPageCheckBox;
	private JCheckBox selectAllCheckBox;
	
	public ReplaceResultViewer(final String queryText, final String queryReplacePaneText, final ArrayList<SearchResult> results, SearchTextAction searchAction){
		super("Search and Replace");
		final JPanel mainPanel = new JPanel();
		this.add(mainPanel, BorderLayout.CENTER);
		mainPanel.setLayout(new BorderLayout());
		this.setSize(800,800);
		this.queryPanel = new JPanel();
		queryPanel.setLayout(new GridLayout(1,3));

		JTextField queryField = new JTextField();
		queryField.setHorizontalAlignment(SwingConstants.LEFT);
		queryField.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		queryField.setText(queryText);
		queryField.setBackground( Color.white );
		queryField.setOpaque(true);
		queryField.setEditable(false);
		queryField.setPreferredSize(new Dimension(380, 40));
		queryPanel.add(queryField,BorderLayout.WEST);

		JTextField replaceField = new JTextField();
		replaceField.setHorizontalAlignment(SwingConstants.LEFT);
		replaceField.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		replaceField.setText(queryReplacePaneText);
		replaceField.setBackground( Color.white );
		replaceField.setOpaque(true);
		replaceField.setEditable(false);
		replaceField.setPreferredSize(new Dimension(380, 40));
		queryPanel.add(replaceField,BorderLayout.EAST);

		mainPanel.add(queryPanel,BorderLayout.NORTH);
		queryPanel.setBorder(new TitledBorder("Query Text:"));
		selectAllThisPageCheckBox = new JCheckBox("Select All in this page");
		selectAllThisPageCheckBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				resultListPanel.selectAllThisPage(selectAllThisPageCheckBox.isSelected());
			}
		});
		resultListPanel = new ReplaceResultListPanel(queryText, queryReplacePaneText, SIZE_TO_DISPLAY,
				results.size(), results, selectAllThisPageCheckBox); 
		mainPanel.add(resultListPanel,BorderLayout.CENTER);
		buttonPanel = new JPanel();
		backButton = new JButton("Back");
		backButton.setEnabled(resultListPanel.isBackButton());
		backButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultListPanel.back();
				backButton.setEnabled(resultListPanel.isBackButton());
				nextButton.setEnabled(resultListPanel.isNextButton());
				validate();
			}
		});	
		nextButton = new JButton("Next");
		nextButton.setEnabled(resultListPanel.isNextButton());
		nextButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultListPanel.next();
				backButton.setEnabled(resultListPanel.isBackButton());
				nextButton.setEnabled(resultListPanel.isNextButton());
				validate();
			}
		});
		replaceAllButton = new JButton("Replace All");
		replaceAllButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SearchAllDialogManager.relaceallnonewwindows(queryReplacePaneText);
				System.out.println("debug: " + WorkspaceWindow.getInstance().getSpread());
				WorkspaceWindow.getInstance().updateSpread(WorkspaceWindow.getInstance().getSpread());
			}
		});

		replaceSelectedButton = new JButton("Replace Selected Item");
		replaceSelectedButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				resultListPanel.replaceSelected();
			}
		});
		selectAllCheckBox = new JCheckBox("Select All");
		selectAllCheckBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				resultListPanel.selectAll(selectAllCheckBox.isSelected());
			}
		});
		buttonPanel.add(backButton);
		buttonPanel.add(nextButton);
		buttonPanel.add(replaceAllButton);
		buttonPanel.add(replaceSelectedButton);
		buttonPanel.add(selectAllThisPageCheckBox);
		buttonPanel.add(selectAllCheckBox);
		mainPanel.add(buttonPanel,BorderLayout.SOUTH);
	}	
}
