package smart_gs.transcription_tool;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;

import smart_gs.image_search.normal.swingui.TranscriptionToolNo1Action;
import smart_gs.logical.Spread;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.transcription_tool.action.CallTesseractAction;

public class TranscriptionToolFrame extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public TranscriptionToolFrame() {
		super("Transcription Tools");
		this.setLayout(new FlowLayout());
		JButton buttonForNo1 = new JButton("Tool No1");
		buttonForNo1.addActionListener(new TranscriptionToolNo1Action());
					
		this.add(buttonForNo1);
		
		JButton buttonForNo2 = new JButton("Tool No2");
		this.add(buttonForNo2);	

		JButton buttonForNo3 = new JButton("tesseract demo");		
		buttonForNo3.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				Spread spread = WorkspaceWindow.getInstance().getSpread();
				List<Spread> targets = new ArrayList<Spread>();
				targets.add(spread);
				ActionListener action = new CallTesseractAction(targets, "eng", true, true, true);
				action.actionPerformed(e);								
			}
			
		});
		this.add(buttonForNo3);
		this.setSize(200, 400);
		this.setVisible(true);
	}

}
