package smart_gs.transcription_tool.tesseract;

import java.util.ArrayList;
import java.util.List;

public class HocrDocument {
	
	private List<HocrLine> lines;
	private String filePath;
	
	public String getText() {
		String sep = System.getProperty("line.separator");
		StringBuffer buf = new StringBuffer();
		for (HocrLine l : this.lines) {
			buf.append(l.getText());
			buf.append(sep);
		}
		return buf.toString();
	}

	public List<HocrLine> getLines() {
		return lines;
	}
	
	public List<HocrWord> getWords() {
		List<HocrWord> words = new ArrayList<HocrWord>();
		for(HocrLine line : this.lines) {
			words.addAll(line.getWords());
		}
		return words;
	}

	public void setLines(List<HocrLine> lines) {
		this.lines = lines;
	}

	public String getFileName() {
		return filePath;
	}

	public void setFileName(String filePath) {
		this.filePath = filePath;
	}
	
	public String toHtml() {
		String html = "";
		for (HocrLine l : lines) {
			html += l.toHtmlElem();
		}
		return String.format("<body>%s</body>", html);
	}

}
