package smart_gs.util;

import java.io.File;

public class DscSearch {

	private static File dscSearch;
	private static File fileCurrent = new File(".");
	private static String utilDirectory = "util/";
	private static String windowsDirectory = "Windows/";
	private static String macosxDirectory = "MacOSX/";
	private static String linuxDirectory = "Linux/";
	private static boolean bDscSearch = false;

	public static String getPath() {

		if(OperatingSystem.isWindows()){
			dscSearch = new File(CanonicalPathString.get(fileCurrent) + "/" + utilDirectory + windowsDirectory  + "DscSearch.exe");
			if(dscSearch.exists() && dscSearch.canExecute()){
				bDscSearch = true;
				return dscSearch.getPath();
			}

			dscSearch = new File(CanonicalPathString.get(fileCurrent) + "/" + "DscSearch.exe");
			if(dscSearch.exists() && dscSearch.canExecute()){
				bDscSearch = true;
				return dscSearch.getPath();
			}
		}

		if(OperatingSystem.isMac()){
			dscSearch = new File(CanonicalPathString.get(fileCurrent) + "/" + utilDirectory + macosxDirectory  + "DscSearch");
			if(dscSearch.exists() && dscSearch.canExecute()){
				bDscSearch = true;
				return dscSearch.getPath();
			}

			dscSearch = new File(CanonicalPathString.get(fileCurrent) + "/" + "DscSearch");
			if(dscSearch.exists() && dscSearch.canExecute()){
				bDscSearch = true;
				return dscSearch.getPath();
			}
		}

		if(OperatingSystem.isUnix()){
			if(OperatingSystem.isAmd64()) {
				dscSearch = new File(CanonicalPathString.get(fileCurrent) + "/" + utilDirectory + linuxDirectory
						+ "DscSearch-amd64");
				if(dscSearch.exists() && dscSearch.canExecute()){
					bDscSearch = true;
					return dscSearch.getPath();
				}
			} else if(OperatingSystem.isX86()) {
				dscSearch = new File(CanonicalPathString.get(fileCurrent) + "/" + utilDirectory + linuxDirectory
						+ "DscSearch-x86");
				if(dscSearch.exists() && dscSearch.canExecute()){
					bDscSearch = true;
					return dscSearch.getPath();
				}				
			}

			dscSearch = new File(CanonicalPathString.get(fileCurrent) + "/" + utilDirectory + linuxDirectory
					+ "DscSearch");
			if(dscSearch.exists() && dscSearch.canExecute()){
				bDscSearch = true;
				return dscSearch.getPath();
			}

			dscSearch = new File(CanonicalPathString.get(fileCurrent) + "/" + "DscSearch");
			if(dscSearch.exists() && dscSearch.canExecute()){
				bDscSearch = true;
				return dscSearch.getPath();
			}
		}
		return null;
	}

	public static boolean isDscSearch(){
		return bDscSearch;
	}

}
