package smart_gs.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceTabbedPane;
import smart_gs.swingui.WorkspaceWindow;
import sml_editor.swingui.GSHTMLEditorTextPane;

// return GSEditor or WorkspaceWindow
public class GSWindowByMouseEvent {
	public AbstractGSWindow getWindow(MouseEvent e) {
		GSEditor gseditor = null;
		SpreadCanvas spreadcanvas = null;
		Component eventcomponent = e.getComponent();

		if (eventcomponent instanceof ImageLabel) {
			ImageLabel imageLabel = (ImageLabel)eventcomponent;
			spreadcanvas = imageLabel.getSpreadCanvas();
			gseditor = spreadcanvas.getGSEditor();
			if (gseditor != null){
				return gseditor;
			} else {
				return WorkspaceWindow.getInstance();
			}
		}

		if (!(eventcomponent instanceof GSHTMLEditorTextPane)) {
			return null;
		}
		
		GSHTMLEditorTextPane theTextPane = (GSHTMLEditorTextPane)eventcomponent;
		//		GSTabbedPane wrkspcwindowTabbedPane= WorkspaceWindow.getInstance().getTabbedPane();
		Container ancestorcomponent = eventcomponent.getParent();
		do {
			if (ancestorcomponent == null ){
				return null;
			}
			ancestorcomponent = ancestorcomponent.getParent();		
		} while (!(ancestorcomponent instanceof AbstractGSWindow));
		return (AbstractGSWindow)ancestorcomponent;
	}
}


