/* $Id: XMLSaver.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Properties;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

import smart_gs.logical.Preference;

public class XMLSaver {

	private Document document;
	private String filename;

	public XMLSaver(Document document, String filename) {
		this.document = document;
		this.filename = filename;
	}

	public synchronized void save() {
		TransformerFactory factory = TransformerFactory.newInstance();
		try {
			Transformer transformer = factory.newTransformer();
			transformer.setOutputProperty("encoding", "UTF-8");
			transformer.setOutputProperty("standalone", "yes");
			transformer.setOutputProperty("indent", "yes");

			DOMSource source = new DOMSource(document);
			File file = new File(filename);

			/*
			 * @memo StreamResultにfileを渡した場合、segfo2dsc.exeの実行に失敗する。
			 * おそらく、ファイルがロックされたままになっているのだろう。
			 * この問題に対処する為、Writerを引数として渡し、close()を呼び出している。 こうするとうまくいく。
			 */
			
			OutputStreamWriter writer = new OutputStreamWriter(
					new FileOutputStream(file), "UTF-8");
			StreamResult result = new StreamResult(writer);
			transformer.transform(source, result);
			
			transformer = null;
			file = null;
			result = null;
			source = null;
			writer.close();
		} catch (TransformerConfigurationException e1) {
			e1.printStackTrace();
		} catch (TransformerException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		factory = null;
	}
}
