#include <stdio.h>

static char version[] = "0.10.4 beta";

// 関数プロトタイプ
void help(void);

/*******************************************************************************
 * ヘルプ
*******************************************************************************/
void help()
{
	printf("バージョン %s\n", version);
	puts("使用方法 : snowcp [option] source dest");
	puts("sourceからdestへコピーする。optionとsourceは複数可。destが存在しない場合は自動的に作成する。");
	puts("");
	puts("オプション");
	puts(" -1 MODE    SHA-1でコンペアを行う。");
	puts("            MODEが1の場合はコピー直後に、");
	puts("            2の場合は全コピー終了後に比較する。");
	puts("            一致しなかった場合はdestを削除する。");
	puts("            (例 : snowcp -1 1 source dest)");
	puts("");
	puts(" -5 MODE    MD5でコンペアを行う。");
	puts("            MODEが1の場合はコピー直後に、");
	puts("            2の場合は全コピー終了後に比較する。");
	puts("            一致しなかった場合はdestを削除する。");
	puts("            (例 : snowcp -5 1 source dest)");
	puts("");
	puts(" -0         ベリファイ・コンペアを行わない。");
	puts("            (-1、-5、-c、-rオプションを無効にする。)");
	puts("");
	puts(" -b NUMBER  バッファの量を指定する（MB単位）。");
	puts("            (例 : snowcp -b 64 source dest)");
	puts("");
	puts(" -c MODE    memcmpで比較する。");
	puts("            MODEが1の場合はコピー直後に、");
	puts("            2の場合は全コピー終了後に比較する。");
	puts("            一致しなかった場合はdestを削除する。");
	puts("            (例 : snowcp -c 1 source dest)");
//	puts("");
//	puts(" -d         ダイレクトI/Oを使用する。");
//	puts("            (このオプションは非推奨です。)");
	puts("");
	puts(" -h         ヘルプを表示する。");
	puts("            (例 : snowcp -h)");
	puts("");
	puts(" --help     ヘルプを表示する。");
	puts("            (例 : snowcp --help)");
	puts("");
	puts(" -i         ファイルを上書きする前に確認する。");
	puts("            (例 : snowcp -i source dest)");
	puts("");
	puts(" -I         -iオプションを無効にする。");
	puts("            (例 : snowcp -I source dest)");
	puts("");
	puts(" -l         ベリファイ・コンペアのログを保存する。");
	puts("            -cオプションのログは保存しない。");
	puts("            (例 : snowcp -1 2 -l source dest)");
	puts("");
	puts(" -L         -lオプションを無効にする。");
	puts("            (例 : snowcp -L source dest)");
	puts("");
	puts(" -m         コピー終了後、コピー元を削除する。");
	puts("            (例 : snowcp -m source dest)");
	puts("");
	puts(" -M         -mオプションを無効にする。");
	puts("            (例 : snowcp -M source dest)");
	puts("");
	puts(" -o         設定を保存する。");
	puts("            (例 : snowcp -o)");
	puts("");
	puts(" -r MODE    ベリファイを行う。");
	puts("            MODEが1の場合はコピー直後に、");
	puts("            2の場合は全コピー終了後にベリファイを実行する。");
	puts("            一致しなかった場合はdestを削除する。");
	puts("            (例 : snowcp -r 1 source dest)");
	puts("");
	puts(" -t MODE    スレッドモードを指定する。");
	puts("            MODEが1の場合は常に同一ドライブモード、");
	puts("            2の場合は常に別ドライブモード、");
	puts("            0の場合は自動判別モードで動作する。");
	puts("            (例 : snowcp -t 1 source dest)");
	puts("");
	puts(" -v         コピー中のファイル名を表示する。");
	puts("            (例 : snowcp -v source dest)");
	puts("");
	puts(" -w MODE    上書きモードを指定する。");
	puts("            MODEが1の場合はサイズか日付が異なる時、");
	puts("            2の場合は日付が新しい時、");
	puts("            3の場合は常に上書きする。");
	puts("            0の場合、上書きしない。");
	puts("            (例 : snowcp -w 3 source dest)");
	puts("");
	puts("注 : オプションは後に入力した方が優先される。例えば snowcp -iw とした場合、-wオプションが有効になる。");
	puts("");
	puts("注 : -iオプションを付けた場合、-i -w 3 と同義になる (サイズの比較等は行われない)。");
	puts("");
	puts("注 : スレッドモードは引数として与えたファイルを基準とするため、サブフォルダにファイルシステムをマウントしている場合は、正常に動作しない。");
}
