#define _GNU_SOURCE

#include "create_symboliclink.h" // inline
#include "struct_CPDD.h"
#include "struct_CPInfo.h"
#include "struct_DPath.h"
#include "struct_OPArg.h"
#include "struct_RData.h"
#include "struct_SDir.h"
#include "append_list.h" // inline
#include "print_error.h" // inline
#include "read_write.h"
#include "xmalloc.h" // inline
#include "xmalloc0.h" // inline

#include <limits.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glib.h>
#include <linux/limits.h>
#include <sys/stat.h>
#include <utime.h>

/* 関数プロトタイプ */
RData * check_target(OPArg *, VList *, SDir *);
void check_overwrite(const OPArg *, const SDir *, CPInfo *, CPDD *);
struct stat * make_directory(CPInfo *, OPArg *, CPDD *);
static VList * dir_traverse(VList *, CPInfo *, OPArg *, SDir *, CPDD *);
static inline void delete_last_slash(const int, char []);
static inline CPInfo * cpinfo_malloc(void);
static inline char * get_dst_plus_srcname(const char *, const char *);
static inline void count_link_plus(CPInfo *, CPDD *);
static inline void count_file_plus(CPInfo *, CPDD *);
static inline void count_dire_plus(CPInfo *, CPDD *);
static inline void ch_time_and_mod_dir(const CPInfo *, const struct stat *, CPDD *);
static inline void clean(const char [], const int);
static inline void fgets_is_null(void);
static inline void set_same_or_different(const VList *, const char *, const char *, CPInfo *, OPArg *);

/*******************************************************************************
*******************************************************************************/
#define LINK_COPY \
{\
	count_link_plus(cpinfo, cpdd);\
	check_overwrite(oparg, sdir, cpinfo, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
}

#define FILE_COPY \
{\
	count_file_plus(cpinfo, cpdd);\
	set_same_or_different(drive_list, tmp_src, tmp_dst, cpinfo, oparg); \
	check_overwrite(oparg, sdir, cpinfo, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
}

#define DIR_COPY \
{\
	_Bool cmp_flag = false;\
	if(src_current_flag == true)\
	{\
		char *s = cpinfo->src;\
		char *d = cpinfo->dst;\
		int s_len = strlen(s);\
		int d_len = strlen(d);\
\
		if(s_len == d_len)\
		{\
			if(strcmp(s, d) == 0)\
			{\
				cmp_flag = true;\
			}\
		}\
		else if(s_len < d_len)\
		{\
			for(;;)\
			{\
				if(*s == *d)\
				{\
					s++;\
					d++;\
				}\
				else \
				{\
					break;\
				}\
\
				if(*s == '\0')\
				{\
\
					if(*d == G_DIR_SEPARATOR)\
					{\
						cmp_flag = true;\
					}\
					break;\
				}\
			}\
		}\
\
		if(cmp_flag == true)\
		{\
			fprintf(stderr, ".をスキップします\n");\
			continue;\
		}\
	}\
\
	if(cmp_flag == false)\
	{\
		set_same_or_different(drive_list, tmp_src, tmp_dst, cpinfo, oparg); \
\
		struct stat *stat_buf;\
\
		if(src_current_flag == false)\
		{\
			count_dire_plus(cpinfo, cpdd);\
			stat_buf = make_directory(cpinfo, oparg, cpdd);\
			file_list = append_list(file_list, (void *)cpinfo);\
		}\
		else \
		{\
			char *current_tmp = g_path_get_dirname(cpinfo->dst);\
			free(cpinfo->dst);\
			cpinfo->dst = current_tmp;\
			/* cpinfoをリストに追加していないので、メモリリークしている。 */\
		}\
\
		file_list = dir_traverse(file_list, cpinfo, oparg, sdir, cpdd);\
\
		if((src_current_flag == false) && (cpinfo->write == true))\
		{\
			ch_time_and_mod_dir(cpinfo, stat_buf, cpdd);\
		}\
	}\
}

/*******************************************************************************
*******************************************************************************/
RData * check_target(OPArg *oparg, VList *drive_list, SDir *sdir)
{
	enum argument_count
	{
		SINGULAR,
		PLURAL,
	} acount;

	VList *file_list = NULL;

	/*
	 * CPDD *cpdd = xmalloc0(sizeof(CPDD));
	 * ↑のコードだと構造体のメンバが0で初期化されるとは限らないらしい。
	 * 大抵の処理系では期待通りに動くらしいけど。
	*/
	CPDD *cpdd = xmalloc(sizeof(CPDD));
	cpdd->file_count = 0;
	cpdd->dir_count = 0;
	cpdd->link_count = 0;
	cpdd->mk_file_count = 0;
	cpdd->mk_dir_count = 0;
	cpdd->mk_link_count = 0;
	cpdd->total_source = 0;
	cpdd->total_read = 0;
	cpdd->total_write = 0;
	cpdd->total_error = 0;
	cpdd->thread_mode_count = 0;

	char tmp_src[PATH_MAX];
	char tmp_dst[PATH_MAX];
	int loop = oparg->src_index;
	int loop_dst = oparg->dst_index;

	_Bool file_found = false;

	if(g_file_test(oparg->argv[loop_dst], G_FILE_TEST_IS_SYMLINK) == TRUE)
	{
		fprintf(stderr, "コピー先がシンボリックリンクです\n");
		exit(EXIT_FAILURE);
	}

	/* 三項演算子 */
	((loop_dst - loop) == 1) ? (acount = SINGULAR) : (acount = PLURAL);

	/* コピー元が.でコピー先が存在しないとき用の処理 */
	switch(acount)
	{
	case SINGULAR:
		{
			char *c = oparg->argv[loop];
			if(
				(c[0] == '.') &&
					(
						(c[1] == '\0') ||
						((c[1] == G_DIR_SEPARATOR) && (c[2] == '\0')) ||
						((c[1] == G_DIR_SEPARATOR) && (c[2] == '.') && (c[3] == '\0'))
					)
			)
			{
				errno = 0;

				if(mkdir(oparg->argv[loop_dst], 0755) == -1)
				{
					if((errno != EEXIST) && (errno != 0))
					{
						print_error("mkdir", __FILE__, __LINE__, cpdd);
						fprintf(stderr, "コピー先フォルダの作成に失敗しました\n");
						exit(EXIT_FAILURE);
					}
				}
			}
		}
		break;
	}

	errno = 0;
	realpath(oparg->argv[loop_dst], tmp_dst);

	if(errno == 0)
	{
		file_found = true;
	}
	else if(errno == ENOENT)
	{
		char *c = g_path_get_dirname(oparg->argv[loop_dst]);

		errno = 0;
		realpath(c, tmp_dst);

		if(errno != 0)
		{
			print_error("realpath", __FILE__, __LINE__, cpdd);
			fprintf(stderr, "コピー先が不定です\n");
			exit(EXIT_FAILURE);
		}

		free(c);
	}
	else
	{
		print_error("realpath", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コピー先が不定です\n");
		exit(EXIT_FAILURE);
	}

	int len_dst = strlen(tmp_dst);
	delete_last_slash(len_dst, tmp_dst);

	for(; loop < loop_dst; loop++)
	{
		_Bool src_current_flag = false;

		/* strcmpは等しければ0を返す */
		if(strcmp(oparg->argv[loop], "..") == 0)
		{
			fprintf(stderr, "..をスキップします\n");
			continue;
		}
		else if(strcmp(oparg->argv[loop], ".") == 0)
		{
			src_current_flag = true;
		}
		/*
		 * メモ
		 * cpコマンドの場合、引数が.だったらそのフォルダにあるファイルをコピーする。
		 * 引数が..だとエラー。
		*/

		_Bool link_flag = false;

		if(g_file_test(oparg->argv[loop], G_FILE_TEST_IS_SYMLINK) == TRUE)
		{
			link_flag = true;
			strcpy(tmp_src, oparg->argv[loop]);
		}
		else
		{
			errno = 0;
			realpath(oparg->argv[loop], tmp_src);

			if(errno != 0)
			{
				print_error("realpath", __FILE__, __LINE__, cpdd);
				fprintf(stderr, "%s\n", oparg->argv[loop]);
				continue;
			}
		}

		int len_src = strlen(tmp_src);
		delete_last_slash(len_src, tmp_src);

		CPInfo *cpinfo = cpinfo_malloc();

		len_src++;
		cpinfo->src = xmalloc(len_src);
		memcpy(cpinfo->src, tmp_src, len_src);
		len_src--;

		if(file_found == true)
		{
			if(g_file_test(tmp_dst, G_FILE_TEST_IS_REGULAR) == TRUE)
			{
				len_dst++;
				cpinfo->dst = xmalloc(len_dst);
				memcpy(cpinfo->dst, tmp_dst, len_dst);
				len_dst--;

				switch(acount)
				{
				case SINGULAR:
					if(link_flag == true)
					{
						fprintf(stderr, "リンク (%s) に対するコピー先が不正 (ファイル) です\n", tmp_src);
						exit(EXIT_FAILURE);
					}
					else if(g_file_test(tmp_src, G_FILE_TEST_IS_REGULAR) == TRUE)
					{
						FILE_COPY
					}
					else if(g_file_test(tmp_src, G_FILE_TEST_IS_DIR) == TRUE)
					{
						fprintf(stderr, "フォルダ (%s) に対するコピー先が不正 (ファイル) です\n", tmp_src);
						exit(EXIT_FAILURE);
					}
					else
					{
						fprintf(stderr, "コピー先が不正 (ファイル) です\n");
						exit(EXIT_FAILURE);
					}
					break;

				default:
					fprintf(stderr, "複数のコピー元に対するコピー先が不正 (ファイル) です\n");
					exit(EXIT_FAILURE);
					break;
				}
			}
			else if(g_file_test(tmp_dst, G_FILE_TEST_IS_DIR) == TRUE)
			{
				cpinfo->dst = get_dst_plus_srcname(tmp_src, tmp_dst);
				if(link_flag == true)
				{
					LINK_COPY
				}
				else if(g_file_test(tmp_src, G_FILE_TEST_IS_REGULAR) == TRUE)
				{
					FILE_COPY
				}
				else if(g_file_test(tmp_src, G_FILE_TEST_IS_DIR) == TRUE)
				{
					DIR_COPY
				}
				else
				{
					fprintf(stderr, "%s をスキップします\n", tmp_src);
				}
			}
			else
			{
				fprintf(stderr, "コピー先が不正です\n");
				exit(EXIT_FAILURE);
			}
		}
		else
		{
			if(acount == PLURAL)
			{
				char *target;
				errno = 0;

				if(mkdir(oparg->argv[loop_dst], 0755) == -1)
				{
					if((errno != EEXIST) && (errno != 0))
					{
						print_error("mkdir", __FILE__, __LINE__, cpdd);
						fprintf(stderr, "コピー先フォルダの作成に失敗しました\n");
						exit(EXIT_FAILURE);
					}
				}
				else
				{
					target = get_dst_plus_srcname(oparg->argv[loop_dst], tmp_dst);
					strcpy(tmp_dst, target);
					cpinfo->dst = get_dst_plus_srcname(tmp_src, target);
					free(target);
					file_found = true;
				}
			}
			else
			{
				cpinfo->dst = get_dst_plus_srcname(oparg->argv[loop_dst], tmp_dst);
			}

			if(link_flag == true)
			{
				LINK_COPY
			}
			else if(g_file_test(tmp_src, G_FILE_TEST_IS_REGULAR) == TRUE)
			{
				FILE_COPY
			}
			else if(g_file_test(tmp_src, G_FILE_TEST_IS_DIR) == TRUE)
			{
				DIR_COPY
			}
			else
			{
				fprintf(stderr, "%s をスキップします\n", tmp_src);
			}
		}
	}

	RData *rdata = xmalloc(sizeof(RData));
	rdata->file_list = file_list;
	rdata->cpdd = cpdd;

/*
	THIS_DIR_FREE
*/
	return rdata;
}

/*******************************************************************************
*******************************************************************************/
#define DO_NOT_OVERWRITE_FLAG \
{\
	cpinfo->write = false;\
	cpinfo->skip = true;\
}

#define FILE_WRITE_OR_CREATE_LINK_OVERWRITE \
{\
	if(cpinfo->src_type == REGULAR)\
	{\
		read_write(oparg, sdir, cpinfo, cpdd);\
	}\
	else \
	{\
		create_symboliclink(oparg, cpinfo, cpdd);\
	}\
}

#define MAKE_THIS_DIR \
this_dir = g_path_get_dirname(cpinfo->dst);

#define THIS_DIR_CHECK \
{\
	char *tmp = g_path_get_dirname(cpinfo->dst);\
	char *tmp2 = this_dir;\
	char *tmp_free = tmp;\
	int tmp_len = strlen(tmp);\
	int this_len = strlen(tmp2);\
	_Bool flag = false;\
\
	if(this_len == tmp_len)\
	{\
		if(strcmp(tmp2, tmp) == 0)\
		{\
			flag = true;\
		}\
	}\
	else if(this_len < tmp_len)\
	{\
		for(;;)\
		{\
			if(*tmp2 == *tmp)\
			{\
				tmp2++;\
				tmp++;\
			}\
			else \
			{\
				break;\
			}\
\
			if(*tmp2 == '\0')\
			{\
\
				if(*tmp == G_DIR_SEPARATOR)\
				{\
					flag = true;\
				}\
				break;\
			}\
		}\
	}\
\
	if(flag == false)\
	{\
		b = false;\
	}\
\
	free(tmp_free);\
}

#define THIS_DIR_FREE \
{\
	if(this_dir != NULL)\
	{\
		free(this_dir);\
		this_dir = NULL;\
	}\
}

enum I_OverWrite_Type
{
	INFO,
	THIS_DIR_YES,
	THIS_DIR_NO,
};

enum I_OverWrite_Type iowt;
static OPFlag I;
static OPFlag WMODE;
static _Bool info_flag;
static char *this_dir;

/*******************************************************************************
*******************************************************************************/
void check_overwrite(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd)
{
	if(info_flag == false)
	{
		iowt = INFO;

		/* 変更される可能性があるオプションはローカル変数に入れておく */
		I = oparg->I;
		WMODE = oparg->WRITE_MODE;
		info_flag = true;
	}

	gboolean fcheck  = g_file_test(cpinfo->dst, G_FILE_TEST_EXISTS);

	/* TRUE・FALSE　→　glib */
	/* true・false　→　stdbool */
	if(fcheck == FALSE)
	{
		if(cpinfo->src_type == REGULAR)
		{
			read_write(oparg, sdir, cpinfo, cpdd);
		}
		else
		{
			/* create_symboliclinkでも再度、上書きチェックを行っている。 */
			create_symboliclink(oparg, cpinfo, cpdd);
		}
	}
	else
	{
		cpinfo->file_test = true;

		if(I == INTERACTIVE)
		{
			/*
			 * -i（上書き確認）モード
			 * ここの処理はgoto使わずに関数にまとめた方が分かりやすいかもしれない
			*/
INPUT:
			/*
			 * gotoのラベルの直後で変数の宣言をすると、
			 * a label can only be part of a statement and a declaration is not a statement
			 * というエラーが出る。
			 */

			switch(iowt)
			{
			case INFO:
				printf("%sは既に存在します。\n", cpinfo->dst);
				puts("上書きしますか? (y: Yes  a: 全てYes  d: このフォルダのみYes  n: No  o: このフォルダのみNo  z: 全てNo)");
				printf(" : ");

				char stdin_buf[NAME_MAX];

				if(fgets(stdin_buf, NAME_MAX, stdin) == NULL)
				{
					fgets_is_null();
				}

				clean(stdin_buf, NAME_MAX);

				if(
					stdin_buf[0] != 'y' &&
					stdin_buf[0] != 'a' &&
					stdin_buf[0] != 'd' &&
					stdin_buf[0] != 'n' &&
					stdin_buf[0] != 'o' &&
					stdin_buf[0] != 'z'
				)
				{
					goto INPUT;
				}

				switch(stdin_buf[0])
				{
				case 'y':	/* 上書き */
					FILE_WRITE_OR_CREATE_LINK_OVERWRITE
					break;

				case 'a':	/* 全て上書き */
					FILE_WRITE_OR_CREATE_LINK_OVERWRITE
					I = NOT;	/* 上書き確認モード無効 */
					/* WMODE = OVERWRITE; */
					/* ↑上書き確認モードでは最初からOVERWRITEになっている */
					break;

				case 'd':	/* このフォルダでのみ上書き */
					FILE_WRITE_OR_CREATE_LINK_OVERWRITE
					iowt = THIS_DIR_YES;
					THIS_DIR_FREE
					MAKE_THIS_DIR
					break;

				case 'n':	/* 上書きしない */
					DO_NOT_OVERWRITE_FLAG
					break;

				case 'o':	/* このフォルダでは上書きしない */
					DO_NOT_OVERWRITE_FLAG
					iowt = THIS_DIR_NO;
					THIS_DIR_FREE
					MAKE_THIS_DIR
					break;

				case 'z':	/* 全て上書きしない */
					DO_NOT_OVERWRITE_FLAG
					I = NOT;	/* 上書き確認モード無効 */
					WMODE = NO_OVERWRITE;	/* 非上書きモード */
					break;
				}
				break;

			case THIS_DIR_YES:
				{
					_Bool b = true;

					THIS_DIR_CHECK

					if(b == true)
					{
						FILE_WRITE_OR_CREATE_LINK_OVERWRITE
					}
					else
					{
						/* 再び上書き確認モードに */
						iowt = INFO;
						THIS_DIR_FREE
						goto INPUT;
					}
				}
				break;

			case THIS_DIR_NO:
				{
					_Bool b = true;

					THIS_DIR_CHECK

					if(b == true)
					{
						DO_NOT_OVERWRITE_FLAG
					}
					else
					{
						/* 再び上書き確認モードに */
						iowt = INFO;
						THIS_DIR_FREE
						goto INPUT;
					}
				}
				break;
			}
		}
		else
		{
			if(WMODE == NO_OVERWRITE)
			{
				DO_NOT_OVERWRITE_FLAG
			}
			else
			{
				FILE_WRITE_OR_CREATE_LINK_OVERWRITE
			}
		}
	}
}

/*******************************************************************************
*******************************************************************************/
struct stat * make_directory(CPInfo *cpinfo, OPArg *oparg, CPDD *cpdd)
{
	errno = 0;
	if(g_file_test(cpinfo->dst, G_FILE_TEST_EXISTS) == TRUE)
	{
		/* フォルダの作成は行わない */
		DO_NOT_OVERWRITE_FLAG
	}
	else if(mkdir(cpinfo->dst, 0755) == -1)
	{
		cpinfo->write = false;

		if((errno != EEXIST) && (errno != 0))
		{
			print_error("mkdir", __FILE__, __LINE__, cpdd);
			fprintf(stderr, "フォルダの作成に失敗しました (%s) \n", cpinfo->dst);
		}
	}
	else
	{
		if(oparg->V == VERBOS)
		{
			printf("%s -> %s\n", cpinfo->src, cpinfo->dst);
			fflush(stdout);
		}

		cpinfo->write = true;
		cpdd->mk_dir_count++;
	}

	struct stat *stat_buf = xmalloc(sizeof(struct stat));

	if(stat(cpinfo->src, stat_buf) != 0)
	{
		print_error("stat", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "フォルダ情報取得エラーです (%s) \n", cpinfo->src);
		free(stat_buf);
		stat_buf = NULL;
	}

	return stat_buf;
}

/*******************************************************************************
*******************************************************************************/
#include <dirent.h>

#define TYPE_IS_LINK \
{\
	count_link_plus(cpinfo, cpdd);\
	check_overwrite(oparg, sdir, cpinfo, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
}

#define TYPE_IS_FILE \
{\
	count_file_plus(cpinfo, cpdd);\
	cpinfo->copy_mode = cpinfo_tmp->copy_mode;\
	check_overwrite(oparg, sdir, cpinfo, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
}

#define TYPE_IS_DIR \
{\
	count_dire_plus(cpinfo, cpdd);\
	cpinfo->copy_mode = cpinfo_tmp->copy_mode;\
	struct stat *stat_buf = make_directory(cpinfo, oparg, cpdd);\
	file_list = append_list(file_list, (void *)cpinfo);\
	/* 再帰 */ \
	file_list = dir_traverse(file_list, cpinfo, oparg, sdir, cpdd);\
	if(cpinfo->write == true) {ch_time_and_mod_dir(cpinfo, stat_buf, cpdd); }\
}

/*******************************************************************************
 * フォルダを走査
*******************************************************************************/
static VList * dir_traverse(VList *file_list, CPInfo *cpinfo_tmp, OPArg *oparg, SDir *sdir, CPDD *cpdd)
{
	DIR *dp = NULL;
	struct dirent *entry = NULL;
	const char *d_name;
	const char *src_dir = cpinfo_tmp->src;
	const char *dst_dir = cpinfo_tmp->dst;

	if((dp = opendir(src_dir)) != NULL)
	{
		while((entry = readdir(dp)) != NULL)
		{
			d_name = entry->d_name;
			/* strcmpは等しければ0を返す（0は偽） */
			if(strcmp(d_name, ".") && strcmp(d_name, ".."))
			{
				int fdir = strlen(src_dir);
				int tdir = strlen(dst_dir);
				int d_len = strlen(d_name);

				CPInfo *cpinfo = cpinfo_malloc();

				/* +2は、 \0 と / の分 */
				cpinfo->src = xmalloc(fdir + d_len + 2);
				cpinfo->dst = xmalloc(tdir + d_len + 2);
				cpinfo->dstfs = cpinfo_tmp->dstfs;
				cpinfo->copy_mode = cpinfo_tmp->copy_mode;
				/*
				 * sprintfは便利だってLeptonさんが言ってた。
				 * printf系の関数は遅い？知るか。
				*/
				sprintf(cpinfo->src, "%s%s%s", src_dir, G_DIR_SEPARATOR_S, d_name);
				sprintf(cpinfo->dst, "%s%s%s", dst_dir, G_DIR_SEPARATOR_S, d_name);

				switch(entry->d_type)
				{
				case DT_LNK:
					TYPE_IS_LINK
					break;

				case DT_REG:
					TYPE_IS_FILE
					break;

				case DT_DIR:
					TYPE_IS_DIR
					break;

				default:
					if(g_file_test(cpinfo->src, G_FILE_TEST_IS_SYMLINK) == TRUE)
					{
						TYPE_IS_LINK
					}
					else if(g_file_test(cpinfo->src, G_FILE_TEST_IS_REGULAR) == TRUE)
					{
						TYPE_IS_FILE
					}
					else if(g_file_test(cpinfo->src, G_FILE_TEST_IS_DIR) == TRUE)
					{
						TYPE_IS_DIR
					}
					else
					{
						fprintf(stderr, "このファイル (%s) をスキップします\n", cpinfo->src);
					}
					break;
				}
			}
		}
		if(closedir(dp) == -1)
		{
			print_error("closedir", __FILE__, __LINE__, cpdd);
		}
	}
	else
	{
		print_error("opendir", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "%s を読み取れませんでした\n", src_dir);
	}

	return file_list;
}

/*******************************************************************************
 * 文字列の最後がパス区切り文字だった場合\0にする
*******************************************************************************/
static inline void delete_last_slash(const int len, char tmp[])
{
	if(tmp[len - 1] == G_DIR_SEPARATOR)
	{
		tmp[len - 1] = '\0';
	}
}

/******************************************************************************
*******************************************************************************/
static inline CPInfo * cpinfo_malloc(void)
{
	CPInfo *cpinfo = xmalloc(sizeof(CPInfo));
	cpinfo->src = NULL;
	cpinfo->dst = NULL;
	cpinfo->dstfs = NULL;
/*	cpinfo->src_type = */
	cpinfo->copy_mode = SAME;
	cpinfo->write = false;
	cpinfo->skip = false;
	cpinfo->hash_check = false;
	cpinfo->file_test = false;
	cpinfo->verify_md5 = NULL;
	cpinfo->src_size = 0;
	cpinfo->dst_size = 0;

	return cpinfo;
}

/*******************************************************************************
 * コピー元ファイル名とコピー先パスを連結する。
 * g_path_get_basename と g_build_path を同時にやる感じ。
*******************************************************************************/
static inline char * get_dst_plus_srcname(const char *src, const char *dst)
{
	char sname[PATH_MAX];
	char *return_name;
	int src_len = strlen(src);
	int dst_len = strlen(dst);
	_Bool flag = false;

	for(int i = src_len - 1; i >= 0; i--)
	{
		/*
		 * 最後のパス区切り文字からコピーするので、
		 * fnameは以下となる。
		 * 
		 * /ファイル名\0
		*/
		if(src[i] == G_DIR_SEPARATOR)
		{
			flag = true;
			int j = 0;

			for(;;)
			{
				sname[j] = src[i];

				if(src[i] == '\0')
				{
					goto BASENAME_END;
				}

				i++;
				j++;
			}
		}
	}

BASENAME_END:

	if(flag == true)
	{
		int name_len = strlen(sname);
		/* +1 はヌル文字（\0）の分 */
		return_name = xmalloc(dst_len + name_len + 1);
		memcpy(return_name, dst, dst_len + 1);
		strcat(return_name, sname);
	}
	else
	{
		/*
		 * 2011年3月19日
		 * メモリ破壊のバグぅうわあああ。
		 * append_list内のxmalloc内で、malloc(): memory corruption
		 * とか出てアボートするバグを直せた。
		 * return_name = xmalloc(src_len + dst_len + 1);
		 * ↑こいつが原因だった。G_DIR_SEPARATOR_Sのことを忘れてた。
		 * 多分これで大丈夫。
		*/
		return_name = xmalloc(src_len + dst_len + (sizeof(G_DIR_SEPARATOR_S) + 1));
		memcpy(return_name, dst, dst_len + 1);
		strcat(return_name, G_DIR_SEPARATOR_S);
		strcat(return_name, src);
	}

	return return_name;
}

/******************************************************************************
*******************************************************************************/
static inline void count_link_plus(CPInfo *cpinfo, CPDD *cpdd)
{
	cpinfo->src_type = SYMBOLICLINK;
	cpdd->link_count++;
}

/******************************************************************************
*******************************************************************************/
static inline void count_file_plus(CPInfo *cpinfo, CPDD *cpdd)
{
	cpinfo->src_type = REGULAR;
	cpdd->file_count++;
}

/******************************************************************************
*******************************************************************************/
static inline void count_dire_plus(CPInfo *cpinfo, CPDD *cpdd)
{
	cpinfo->src_type = DIRECTORY;
	cpdd->dir_count++;
}

/*******************************************************************************
*******************************************************************************/
static inline void ch_time_and_mod_dir(const CPInfo *cpinfo, const struct stat *stat_buf, CPDD *cpdd)
{
	errno = 0;

	if(chmod(cpinfo->dst, stat_buf->st_mode) == -1)
	{
		print_error("chmod", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "フォルダ情報変更エラーです (%s) \n", cpinfo->dst);
	}

/*
	if(chown(cpinfo->dst, stat_buf->st_uid, stat_buf->st_gid) == -1)
	{
		print_error("chown", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "フォルダ情報変更エラーです (%s) \n", cpinfo->dst);
	}
*/

	chown(cpinfo->dst, stat_buf->st_uid, stat_buf->st_gid);

	static struct utimbuf times;
	times.actime  = stat_buf->st_atime;
	times.modtime = stat_buf->st_mtime;

	if(utime(cpinfo->dst, &times) == -1)
	{
		print_error("utime", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "フォルダ情報変更エラーです (%s) \n", cpinfo->dst);
	}
}

/*******************************************************************************
 * 入力バッファのクリア
*******************************************************************************/
static inline void clean(const char stdin_buf[], const int INPUT_LEN)
{
	/* バッファチェック */
	_Bool flag = false;
	for(int i = 0; i < INPUT_LEN; i++)
	{
		if(stdin_buf[i] == '\n')
		{
			flag = true;
			break;
		}
	}
	/* 入力バッファの掃除 */
	if(flag == false)
	{
		while(getchar() != '\n');
	}
}

/*******************************************************************************
 * fgetsの戻り値がNULLだった場合
*******************************************************************************/
static inline void fgets_is_null(void)
{
	fprintf(stderr, "fgetsの戻り値がNULLです\n");
	exit(EXIT_FAILURE);
}

/******************************************************************************
*******************************************************************************/
#define PATH_CHECK \
const char *mp = tmp->mount_point;\
_Bool flag = false;\
\
for(;;)\
{\
	if(*path == *mp)\
	{\
		path++;\
		mp++;\
	}\
	else \
	{\
		break;\
	}\
\
	if(*mp == '\0')\
	{\
		if((*path == G_DIR_SEPARATOR) || (*path == '\0'))\
		{\
			flag = true;\
		}\
		break;\
	}\
}

/******************************************************************************
 * ドライブが同一かどうか調べる
*******************************************************************************/
static inline void set_same_or_different(const VList *drive_list, const char *src, const char *dst, CPInfo *cpinfo, OPArg *oparg)
{
	/*
	 * キャストしないと警告が出る
	 * warning: initialization discards qualifiers from pointer target type
	*/
	VList *tmplist = (VList *)drive_list;
	char *srcdev = NULL;
	char *dstdev = NULL;

	for(;;)
	{
		DPath *tmp = (DPath *)tmplist->data;
/*
printf("%s %s\n", tmp->device, tmp->mount_point);
*/
		if((tmp->mount_point[1] == '\0') && (tmp->mount_point[0] == G_DIR_SEPARATOR))
		{
			if(srcdev == NULL)
			{
				srcdev = tmp->device;
			}

			if(dstdev == NULL)
			{
				dstdev = tmp->device;
				cpinfo->dstfs = tmp->fs;
			}

			goto DEV_CHECK_SKIP;
		}

		{
			const char *path = src;

			PATH_CHECK

			if(flag == true)
			{
				srcdev = tmp->device;
			}
		}

		{
			const char *path = dst;

			PATH_CHECK

			if(flag == true)
			{
				dstdev = tmp->device;
				cpinfo->dstfs = tmp->fs;
			}
		}

DEV_CHECK_SKIP:
;
		if(tmplist->next != NULL)
		{
			tmplist = tmplist->next;
		}
		else
		{
			break;
		}
	}

	if((srcdev != NULL) && (dstdev != NULL))
	{
		if(strcmp(srcdev, dstdev) == 0)
		{
			cpinfo->copy_mode = SAME;
		}
		else
		{
			cpinfo->copy_mode = DIFFERENT;
		}
	}
	else
	{
		cpinfo->copy_mode = SAME;
	}

	switch(oparg->THREAD_MODE)
	{
/*
	case DRIVE_SAME:
		cpinfo->copy_mode = SAME;
		break;
*/
	case DRIVE_DIFFERENT:
		cpinfo->copy_mode = DIFFERENT;
		break;

	case DRIVE_AUTO:
		break;

	default:
		cpinfo->copy_mode = SAME;
		break;
	}
}
