#define _GNU_SOURCE

#include "print_error.h" // inline
#include "replace_string.h" // inline
#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "write_log_hash_check.h" // inline

#include <unistd.h>

/* 置換後の文字列の長さをPATH_MAXの三倍までと仮定 */
static const int REPLACE_LEN = PATH_MAX * 3;

static FILE *pipe_src;
static FILE *pipe_dst;
static char *pipe_buf_src;
static char *pipe_buf_dst;
static char *re_src;
static char *re_dst;
static char *command_src;
static char *command_dst;
static int read_size;
static char *ssrc;
static char *ddst;

/* 関数プロトタイプ */
void compare_hash(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd);

/*******************************************************************************
*******************************************************************************/
void compare_hash(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd)
{
	pipe_src = NULL;
	pipe_dst = NULL;
	pipe_buf_src = alloca(PATH_MAX);
	pipe_buf_dst = alloca(PATH_MAX);
	re_src = alloca(REPLACE_LEN);
	re_dst = alloca(REPLACE_LEN);
	command_src = alloca(REPLACE_LEN);
	command_dst = alloca(REPLACE_LEN);

	/*
	 * 以下のコードだとメモリ破壊（cpinfo->dstの破壊）を起こしていた。
	 * memset(pipe_buf_src, 0, PATH_MAX);
	 * memset(pipe_buf_dst, 0, PATH_MAX);
	*/
	pipe_buf_src[0] = '\0';
	pipe_buf_dst[0] = '\0';

	strcpy(re_src, cpinfo->src);
	strcpy(re_dst, cpinfo->dst);

	/*
	 * 特殊文字の置換
	 * bashのみ対応、他は未確認。
	 * かならず最初に\を置換する。
	*/
	replace_string(re_src, "\\", "\\\\", REPLACE_LEN);
	replace_string(re_src, "\"", "\\\"", REPLACE_LEN);
	replace_string(re_src, "`", "\\`", REPLACE_LEN);
	replace_string(re_src, "$", "\\$", REPLACE_LEN);

	replace_string(re_dst, "\\", "\\\\", REPLACE_LEN);
	replace_string(re_dst, "\"", "\\\"", REPLACE_LEN);
	replace_string(re_dst, "`", "\\`", REPLACE_LEN);
	replace_string(re_dst, "$", "\\$", REPLACE_LEN);

	/*
	 * 特殊文字を置換済みの場合、'や"で括ると動作しなくなる
	 * 'で括る場合、文字列中に'があると動作しない。
	 * なので"でくくる。
	 */
	if(oparg->CHECK == ONE)
	{
		sprintf(command_src, "%s%s%s%s", "sha1sum -- ", "\"", re_src, "\"");
		sprintf(command_dst, "%s%s%s%s", "sha1sum -- ", "\"", re_dst, "\"");
	}
	else
	{
		sprintf(command_src, "%s%s%s%s", "md5sum -- ", "\"", re_src, "\"");
		sprintf(command_dst, "%s%s%s%s", "md5sum -- ", "\"", re_dst, "\"");
	}

	{
		errno = 0;
		/* バッファ掃除用の領域 */
		static char ctmp[PATH_MAX];

		if(cpinfo->copy_mode == DIFFERENT)
		{
			pipe_src = popen(command_src, "r");
			pipe_dst = popen(command_dst, "r");

			if((pipe_src != NULL) && (pipe_dst != NULL))
			{
				read_size = fread(pipe_buf_src, 1, PATH_MAX, pipe_src);
				/* パイプのバッファを空にするためにグルグル回す */
				while(fread(ctmp, 1, PATH_MAX, pipe_src) > 0) {}

				read_size = fread(pipe_buf_dst, 1, PATH_MAX, pipe_dst);
				while(fread(ctmp, 1, PATH_MAX, pipe_dst) > 0) {}
			}
		}
		else
		{
			pipe_src = popen(command_src, "r");

			if(pipe_src != NULL)
			{
				read_size = fread(pipe_buf_src, 1, PATH_MAX, pipe_src);
				while(fread(ctmp, 1, PATH_MAX, pipe_src) > 0) {}
			}

			pipe_dst = popen(command_dst, "r");

			if(pipe_dst != NULL)
			{
				read_size = fread(pipe_buf_dst, 1, PATH_MAX, pipe_dst);
				while(fread(ctmp, 1, PATH_MAX, pipe_dst) > 0) {}
			}
		}
	}

	if((pipe_src != NULL) && (pipe_dst != NULL))
	{
		/* チェックしとかないと (半角スペース)が含まれていない場合、SIGSEGVで落ちる */
		if(strstr(pipe_buf_src, " ") && strstr(pipe_buf_dst, " "))
		{
			ssrc = strtok(pipe_buf_src, " ");
			ddst = strtok(pipe_buf_dst, " ");

			/*
			 * Ubuntu 10.10で、ファイル名に\が含まれているファイルをsha1sumやmd5sumに渡すと、
			 * 何故かハッシュ値の前に\が挿入されるっぽい。バグか？
			 * その所為で文字列の長さが33や41になってハッシュ値が不一致と判定されるので、
			 * 文字列の先頭が\だった場合、文字列を一つ前にずらす。
			 */
			if(ssrc[0] == '\\')
			{
				memmove(ssrc, ssrc + 1, strlen(ssrc));
			}

			if(ddst[0] == '\\')
			{
				memmove(ddst, ddst + 1, strlen(ddst));
			}

			/* MD5 == 32桁　SHA-1 == 40桁 */
			if((strcmp(ssrc, ddst) == 0) && ((strlen(ssrc) == 32) || (strlen(ssrc) == 40)))
			{
				cpinfo->hash_check = true;

				if(oparg->V == VERBOS)
				{
					printf("%s : %s\n", ssrc, cpinfo->src);
					printf("%s : %s\n", ddst, cpinfo->dst);
					fflush(stdout);
				}

				if(oparg->L == LOG)
				{
					write_log_hash_check(cpinfo, ssrc, ddst, sdir, cpdd, true);
				}
			}
			else
			{
				fprintf(stderr, "ハッシュ値が一致しませんでした、%sを削除します\n", cpinfo->dst);
				print_error("NODATA", __FILE__, __LINE__, cpdd);
				write_log_hash_check(cpinfo, ssrc, ddst, sdir, cpdd, false);
				cpinfo->write = false;

				errno = 0;
				if(unlink(cpinfo->dst) == -1)
				{
					if(errno != ENOENT)
					{
						print_error("unlink", __FILE__, __LINE__, cpdd);
						fprintf(stderr, "%s の削除に失敗しました\n", cpinfo->dst);
					}
				}
			}
		}
		else
		{
			print_error("NODATA", __FILE__, __LINE__, cpdd);
			fprintf(stderr, "コンペアに失敗しました\n");
			fprintf(stderr, "%s\n", cpinfo->src);
			fprintf(stderr, "%s\n", cpinfo->dst);
			write_log_hash_check(cpinfo, "NULL", "NULL", sdir, cpdd, false);
		}
	}
	else
	{
		print_error("NODATA", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアに失敗しました\n");
		fprintf(stderr, "%s\n", cpinfo->src);
		fprintf(stderr, "%s\n", cpinfo->dst);
		write_log_hash_check(cpinfo, "NULL", "NULL", sdir, cpdd, false);
	}

	/* 念のため、pipe詰まり対策 */
	for(;;)
	{
		read_size = 0;
		read_size += fread(pipe_buf_src, 1, PATH_MAX, pipe_src);
		read_size += fread(pipe_buf_dst, 1, PATH_MAX, pipe_dst);
		if(read_size <= 0)
		{
			break;
		}
	}

	pclose(pipe_src);
	pclose(pipe_dst);
}
