#define _GNU_SOURCE

#include "print_error.h"
#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "verify_md5sum.h"
#include "write_log_hash_check.h"

#include "md5.h"

#include <stdbool.h>
#include <stdlib.h>

#include <fcntl.h>
#include <malloc.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define BUF_NUM 2

static void *buf[BUF_NUM];
static int fd;
static int buffer_size_local;
static long psize;
static md5_state_t state;
static int read_size[BUF_NUM];
static off_t total;
static int r_number;
static int a_number;
static _Bool read_err;
static _Bool read_finish;

/* 関数プロトタイプ */
void verify_hash(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd);
static void o_direct(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd);
static void * read_func(void *dummy);
static void * append_func(void *dummy);

/*******************************************************************************
*******************************************************************************/
void verify_hash(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd)
{
	fd = 0;
	buffer_size_local = oparg->buffer_size / 2;
	read_size[0] = 0;
	read_size[1] = 0;
	total = 0;
	read_err = false;
	read_finish = false;

	if(psize == 0)
	{
		psize = sysconf(_SC_PAGESIZE);
	}

	_Bool open_flag;

	errno = 0;
	if((fd = open(cpinfo->dst, O_NOATIME | O_NOFOLLOW | O_DIRECT | O_RDONLY)) == -1)
	{
		switch(errno)
		{
		case EPERM:
			if((fd = open(cpinfo->dst, O_NOFOLLOW | O_DIRECT | O_RDONLY)) == -1)
			{
				open_flag = false;
			}
			else
			{
				open_flag = true;
			}
			break;

		default:
			open_flag = false;
			break;
		}
	}
	else
	{
		open_flag = true;
	}

	if(open_flag == true)
	{
		o_direct(oparg, sdir, cpinfo, cpdd);
	}
	else
	{
		verify_md5sum(oparg, sdir, cpinfo, cpdd);
	}

	if((open_flag == true) && (close(fd) == -1))
	{
		print_error("close", __FILE__, __LINE__, cpdd);
	}
/*
	free(buf[0]);
	free(buf[1]);
*/
}

/*******************************************************************************
*******************************************************************************/
static void o_direct(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd)
{
	static _Bool get_memory = false;

	if((buf[0] == NULL) && (buf[1] == NULL))
	{
		if((posix_memalign((void **)&buf[0], psize, buffer_size_local) != 0) || (posix_memalign((void **)&buf[1], psize, buffer_size_local) != 0))
		{
			fprintf(stderr, "ベリファイに失敗しました\n");
			fprintf(stderr, "`%s'\n", cpinfo->dst);
			print_error("posix_memalign", __FILE__, __LINE__, cpdd);
			write_log_hash_check(cpinfo, cpinfo->src_md5, "NULL", sdir, cpdd, false);

			if(buf[0] != NULL)
			{
				free(buf[0]);
				buf[0] = NULL;
			}

			if(buf[1] != NULL)
			{
				free(buf[1]);
				buf[1] = NULL;
			}
		}
		else
		{
			get_memory = true;
		}
	}

	switch(get_memory)
	{
	case true:
		md5_init(&state);

		r_number = 0;
		a_number = 1;
		pthread_t t1;
		pthread_t t2;

		pthread_create(&t1, NULL, read_func, (void *)&r_number);
		pthread_join(t1, NULL);

		int swap;

		for(;;)
		{
			swap = r_number;
			r_number = a_number;
			a_number = swap;

			pthread_create(&t1, NULL, read_func, (void *)&r_number);
			pthread_create(&t2, NULL, append_func, (void *)&a_number);

			pthread_join(t1, NULL);
			pthread_join(t2, NULL);

			if((read_finish == true) || (read_err == true))
			{
				break;
			}
		}

		md5_byte_t digest[16];
		char hex_output[(16 * 2) + 1];
		hex_output[0] = '\0';

		md5_finish(&state, digest);

		for(int di = 0; di < 16; ++di)
		{
			sprintf(hex_output + di * 2, "%02x", digest[di]);
		}

		_Bool unlink_miss_file = false;

		if(strcmp(cpinfo->src_md5, hex_output) == 0)
		{
			cpinfo->hash_check = true;

			if(oparg->V == VERBOS)
			{
				printf("%s : %s\n", cpinfo->src_md5, cpinfo->src);
				printf("%s : %s\n", hex_output, cpinfo->dst);
				fflush(stdout);
			}

			if(oparg->L == LOG)
			{
				write_log_hash_check(cpinfo, cpinfo->src_md5, hex_output, sdir, cpdd, true);
			}
		}
		else if(cpinfo->src_size > total)
		{
			unlink_miss_file = true;
			fprintf(stderr, "ファイルの読み込みに失敗しました\n");
			fprintf(stderr, "`%s' を削除します\n", cpinfo->dst);
		}
		else
		{
			unlink_miss_file = true;
			fprintf(stderr, "ハッシュ値が一致しませんでした\n");
			fprintf(stderr, "`%s' を削除します\n", cpinfo->dst);
		}

		if(unlink_miss_file == true)
		{
			print_error("NODATA", __FILE__, __LINE__, cpdd);
			write_log_hash_check(cpinfo, cpinfo->src_md5, hex_output, sdir, cpdd, false);
			cpinfo->dst_para = DELETE;

			errno = 0;
			if((unlink(cpinfo->dst) == -1) && (errno != ENOENT))
			{
				print_error("unlink", __FILE__, __LINE__, cpdd);
				fprintf(stderr, "`%s' の削除に失敗しました\n", cpinfo->dst);
			}
		}

		break;

	case false:
		fprintf(stderr, "ベリファイ出来ません\n");
		fprintf(stderr, "メモリの確保に失敗しました\n");
		print_error("NODATA", __FILE__, __LINE__, cpdd);
		write_log_hash_check(cpinfo, cpinfo->src_md5, "NULL", sdir, cpdd, false);
		cpinfo->dst_para = INITIAL;
		break;
	}
}

/*******************************************************************************
*******************************************************************************/
static void * read_func(void *dummy)
{
	int i = r_number;

	/* 
	 * O_DIRECTを使用するとアライメントの調整などが面倒なので、
	 * full_read や safe_read のようなエラー処理は行わない。
	*/
	read_size[i] = read(fd, buf[i], buffer_size_local);

	if(read_size[i] == 0)
	{
		read_finish = true;
	}
	else if(read_size[i] < 0)
	{
		read_err = true;
	}
	else
	{
		total += read_size[i];
	}

	dummy++;	/* コンパイル時のwarningを出さないようにするため */
	return NULL;
}

/*******************************************************************************
*******************************************************************************/
static void * append_func(void *dummy)
{
	int i = a_number;

	md5_append(&state, buf[i], read_size[i]);

	dummy++;	/* コンパイル時のwarningを出さないようにするため */
	return NULL;
}
