/*
 * Decompiled with CFR 0.152.
 */
package soba.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soba.core.ClassInfo;
import soba.core.FieldInfo;
import soba.core.IDynamicBindingResolver;
import soba.core.MethodInfo;
import soba.core.method.CallSite;
import soba.core.method.FieldAccess;

public class ClassHierarchy
implements IDynamicBindingResolver {
    private boolean frozen = false;
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private Map<String, ClassInfo> entries;
    private Map<String, String> parentClass;
    private Map<String, List<String>> parentInterfaces;
    private Map<String, Set<String>> subtypes = new HashMap<String, Set<String>>();
    private Set<String> requestedClasses;
    private static List<String> EMPTY = Collections.unmodifiableList(new ArrayList(0));

    public ClassHierarchy() {
        this.parentClass = new HashMap<String, String>();
        this.parentInterfaces = new HashMap<String, List<String>>();
        this.entries = new HashMap<String, ClassInfo>();
        this.requestedClasses = new HashSet<String>();
    }

    @Override
    public MethodInfo[] resolveCall(CallSite cs) {
        return this.resolveCall(cs.getClassName(), cs.getMethodName(), cs.getDescriptor(), !cs.isStaticOrSpecial());
    }

    public MethodInfo[] resolveCall(String className, String methodName, String methodDesc, boolean dynamic) {
        if (!dynamic) {
            MethodInfo[] methodInfoArray;
            MethodInfo m = this.resolveSpecialCall(className, methodName, methodDesc);
            if (m == null) {
                methodInfoArray = new MethodInfo[]{};
            } else {
                MethodInfo[] methodInfoArray2 = new MethodInfo[1];
                methodInfoArray = methodInfoArray2;
                methodInfoArray2[0] = m;
            }
            return methodInfoArray;
        }
        return this.resolveDynamicCall(className, methodName, methodDesc);
    }

    private MethodInfo[] resolveDynamicCall(String className, String methodName, String methodDesc) {
        assert (className != null && methodName != null && methodDesc != null) : "Parameters cannot be null.";
        String targetTypeName = className;
        MethodInfo topDecl = this.findDeclaration(className, methodName, methodDesc);
        if (topDecl == null) {
            return new MethodInfo[0];
        }
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>(16);
        if (topDecl.hasMethodBody()) {
            result.add(topDecl);
        }
        if (!this.isArrayType(targetTypeName)) {
            HashSet<String> checkedClasses = new HashSet<String>();
            Stack<String> classes = new Stack<String>();
            classes.add(targetTypeName);
            while (!classes.empty()) {
                String currentClass = (String)classes.pop();
                if (checkedClasses.contains(currentClass)) continue;
                checkedClasses.add(currentClass);
                ClassInfo currentClassInfo = this.getClassInfo(currentClass);
                if (currentClassInfo == null) continue;
                MethodInfo m = currentClassInfo.findMethod(methodName, methodDesc);
                if (m != null && m.hasMethodBody() && m != topDecl) {
                    result.add(m);
                }
                if (m != null && !m.isOverridable()) continue;
                for (String c : this.getSubtypes(currentClass)) {
                    if (m != null && m.isPackagePrivate()) {
                        if (!this.isSamePackage(c, currentClass)) continue;
                        classes.push(c);
                        continue;
                    }
                    classes.push(c);
                }
            }
        }
        MethodInfo[] resultArray = new MethodInfo[result.size()];
        int i = 0;
        while (i < result.size()) {
            resultArray[i] = (MethodInfo)result.get(i);
            ++i;
        }
        return resultArray;
    }

    public MethodInfo resolveSpecialCall(String className, String methodName, String methodDesc) {
        MethodInfo m = this.findDeclaration(className, methodName, methodDesc);
        if (m != null) {
            return m;
        }
        return null;
    }

    private MethodInfo findDeclaration(String className, String methodName, String methodDesc) {
        String currentClass = className;
        while (currentClass != null) {
            ClassInfo currentClassInfo = this.getClassInfo(currentClass);
            if (currentClassInfo != null) {
                MethodInfo m = currentClassInfo.findMethod(methodName, methodDesc);
                if (m != null) {
                    return m;
                }
                currentClass = this.getSuperClass(currentClass);
                continue;
            }
            if (this.isArrayType(currentClass)) {
                currentClass = this.getSuperClass(currentClass);
                continue;
            }
            return null;
        }
        LinkedList<String> worklist = new LinkedList<String>();
        currentClass = className;
        while (currentClass != null) {
            worklist.addAll(this.getSuperInterfaces(currentClass));
            currentClass = this.getSuperClass(currentClass);
        }
        while (!worklist.isEmpty()) {
            String interfaceName = (String)worklist.pollFirst();
            ClassInfo currentClassInfo = this.getClassInfo(interfaceName);
            if (currentClassInfo != null) {
                MethodInfo m = currentClassInfo.findMethod(methodName, methodDesc);
                if (m != null) {
                    return m;
                }
                worklist.addAll(this.getSuperInterfaces(interfaceName));
                continue;
            }
            if (this.isArrayType(interfaceName)) continue;
            return null;
        }
        return null;
    }

    public FieldInfo resolveField(FieldAccess access) {
        String owner = this.resolveFieldOwner(access);
        return this.getClassInfo(owner).findField(access.getFieldName(), access.getDescriptor());
    }

    private String resolveFieldOwner(FieldAccess access) {
        if (access.isStatic()) {
            return this.resolveStaticFieldOwner(access.getClassName(), access.getFieldName(), access.getDescriptor());
        }
        return this.resolveInstanceFieldOwner(access.getClassName(), access.getFieldName(), access.getDescriptor());
    }

    public String resolveInstanceFieldOwner(String className, String fieldName, String fieldDesc) {
        String current = className;
        while (current != null) {
            ClassInfo c = this.getClassInfo(current);
            if (c != null) {
                if (c.findField(fieldName, fieldDesc) != null) {
                    return current;
                }
                current = c.getSuperClass();
                continue;
            }
            current = null;
        }
        return null;
    }

    public String resolveStaticFieldOwner(String className, String fieldName, String fieldDesc) {
        ClassInfo c = this.getClassInfo(className);
        if (c == null) {
            return null;
        }
        if (c != null && c.findField(fieldName, fieldDesc) != null) {
            return className;
        }
        Stack<String> worklist = new Stack<String>();
        worklist.push(className);
        while (!worklist.isEmpty()) {
            String current = (String)worklist.pop();
            c = this.getClassInfo(current);
            if (c == null) continue;
            if (c.findField(fieldName, fieldDesc) != null) {
                return current;
            }
            if (c.getInterfaces() == null) continue;
            worklist.addAll(c.getInterfaces());
        }
        c = this.getClassInfo(className);
        if (c.getSuperClass() != null) {
            return this.resolveStaticFieldOwner(c.getSuperClass(), fieldName, fieldDesc);
        }
        return null;
    }

    public void freeze() {
        assert (!this.frozen) : "ClassHierarchy is already frozen.";
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public Set<String> getRequestedClasses() {
        return this.requestedClasses;
    }

    public ClassInfo getClassInfo(String className) {
        ClassInfo c = this.entries.get(className);
        if (c == null) {
            this.requestedClasses.add(className);
        }
        return c;
    }

    public int getClassCount() {
        return this.entries.size();
    }

    public Iterable<String> getClasses() {
        return this.entries.keySet();
    }

    public boolean isSamePackage(String typeName1, String typeName2) {
        ClassInfo c1 = this.entries.get(typeName1);
        ClassInfo c2 = this.entries.get(typeName2);
        if (c1 == null) {
            this.requestedClasses.add(typeName1);
        }
        if (c2 == null) {
            this.requestedClasses.add(typeName2);
        }
        return c1 != null && c2 != null && c1.getPackageName().equals(c2.getPackageName());
    }

    public String getSuperClass(String className) {
        if (this.isArrayType(className)) {
            return JAVA_LANG_OBJECT;
        }
        if (!this.parentClass.containsKey(className)) {
            this.requestedClasses.add(className);
        }
        return this.parentClass.get(className);
    }

    public Collection<String> getSuperInterfaces(String className) {
        if (this.isArrayType(className)) {
            return EMPTY;
        }
        if (this.parentInterfaces.containsKey(className)) {
            return this.parentInterfaces.get(className);
        }
        if (!this.entries.containsKey(className)) {
            this.requestedClasses.add(className);
        }
        return EMPTY;
    }

    public Collection<String> listAllSuperTypes(String className) {
        if (!this.entries.containsKey(className)) {
            this.requestedClasses.add(className);
        }
        HashSet<String> classes = new HashSet<String>();
        LinkedList<String> worklist = new LinkedList<String>();
        worklist.add(className);
        while (!worklist.isEmpty()) {
            String name = (String)worklist.poll();
            String superClass = this.getSuperClass(name);
            if (superClass != null && !classes.contains(superClass)) {
                classes.add(superClass);
                worklist.add(superClass);
            }
            for (String s : this.getSuperInterfaces(name)) {
                if (s == null || classes.contains(s)) continue;
                classes.add(s);
                worklist.add(s);
            }
        }
        return classes;
    }

    public boolean isArrayType(String typeName) {
        return typeName.endsWith("[]");
    }

    public Collection<String> getSubtypes(String typeName) {
        if (!this.entries.containsKey(typeName)) {
            this.requestedClasses.add(typeName);
        }
        if (this.subtypes.containsKey(typeName)) {
            return this.subtypes.get(typeName);
        }
        return EMPTY;
    }

    public Collection<String> getAllSubtypes(Iterable<String> typeNames) {
        Stack<String> worklist = new Stack<String>();
        for (String t : typeNames) {
            worklist.push(t);
        }
        HashSet<String> visited = new HashSet<String>();
        while (!worklist.isEmpty()) {
            String t = (String)worklist.pop();
            if (visited.contains(t)) continue;
            visited.add(t);
            worklist.addAll(this.getSubtypes(t));
        }
        return visited;
    }

    public void registerClass(ClassInfo c) {
        if (this.frozen) {
            throw new FrozenHierarchyException();
        }
        this.entries.put(c.getClassName(), c);
        this.registerSuperClass(c.getClassName(), c.getSuperClass());
        this.registerSubtype(c.getClassName(), c.getSuperClass());
        this.registerInterfaces(c.getClassName(), c.getInterfaces());
        for (String interfaceName : c.getInterfaces()) {
            this.registerSubtype(c.getClassName(), interfaceName);
        }
    }

    public void registerSuperClass(String current, String parent) {
        if (this.frozen) {
            throw new FrozenHierarchyException();
        }
        this.parentClass.put(current, parent);
    }

    public void registerSubtype(String typeName, String parentTypeName) {
        if (this.frozen) {
            throw new FrozenHierarchyException();
        }
        if (this.subtypes.containsKey(parentTypeName)) {
            this.subtypes.get(parentTypeName).add(typeName);
        } else {
            HashSet<String> types = new HashSet<String>();
            types.add(typeName);
            this.subtypes.put(parentTypeName, types);
        }
    }

    public void registerInterfaces(String current, List<String> interfaces) {
        if (this.frozen) {
            throw new FrozenHierarchyException();
        }
        this.parentInterfaces.put(current, interfaces);
    }

    public class FrozenHierarchyException
    extends RuntimeException {
        private static final long serialVersionUID = -8288161390304221032L;
    }
}

