/*
 * Decompiled with CFR 0.152.
 */
package soba.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import soba.core.ClassHierarchy;
import soba.core.ClassInfo;
import soba.core.ExampleProgram;
import soba.core.MethodInfo;
import soba.core.method.FieldAccess;

public class ClassHierarchyTest
implements ExampleProgram {
    private ClassHierarchy ch;
    private static ClassInfo c;
    private static ClassInfo d;
    private static ClassInfo e;
    private static ClassInfo f;
    private static ClassInfo g;
    private static ClassInfo h;
    private static ClassInfo i;
    private static ClassInfo j;
    private static ClassInfo k;

    @BeforeClass
    public static void setUpClassInfo() throws IOException {
        c = new ClassInfo("C.class", new FileInputStream("bin/soba/testdata/inheritance1/C.class"));
        d = new ClassInfo("D.class", new FileInputStream("bin/soba/testdata/inheritance1/D.class"));
        e = new ClassInfo("E.class", new FileInputStream("bin/soba/testdata/inheritance2/E.class"));
        f = new ClassInfo("F.class", new FileInputStream("bin/soba/testdata/inheritance2/F.class"));
        g = new ClassInfo("G.class", new FileInputStream("bin/soba/testdata/inheritance1/G.class"));
        h = new ClassInfo("H.class", new FileInputStream("bin/soba/testdata/inheritance2/H.class"));
        i = new ClassInfo("I.class", new FileInputStream("bin/soba/testdata/inheritance1/I.class"));
        j = new ClassInfo("I.class", new FileInputStream("bin/soba/testdata/inheritance1/J.class"));
        k = new ClassInfo("I.class", new FileInputStream("bin/soba/testdata/inheritance1/K.class"));
    }

    @Before
    public void createHierarchy() {
        this.ch = new ClassHierarchy();
        this.ch.registerClass(c);
        this.ch.registerClass(d);
        this.ch.registerClass(e);
        this.ch.registerClass(f);
        this.ch.registerClass(g);
        this.ch.registerClass(h);
        this.ch.registerClass(i);
        this.ch.registerClass(j);
        this.ch.registerClass(k);
    }

    @Test
    public void testClasses() {
        Assert.assertThat((Object)this.ch.getClassCount(), (Matcher)Matchers.is((Object)9));
        Assert.assertThat(this.ch.getClasses(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"soba/testdata/inheritance1/C", "soba/testdata/inheritance1/D", "soba/testdata/inheritance2/E", "soba/testdata/inheritance2/F", "soba/testdata/inheritance1/G", "soba/testdata/inheritance2/H", "soba/testdata/inheritance1/I", "soba/testdata/inheritance1/J", "soba/testdata/inheritance1/K"}));
        Assert.assertThat(this.ch.getRequestedClasses(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetClassInfo() {
        Assert.assertThat((Object)this.ch.getClassInfo("soba/testdata/inheritance1/C"), (Matcher)Matchers.is((Object)c));
        Assert.assertThat((Object)this.ch.getClassInfo("soba/testdata/inheritance1/D"), (Matcher)Matchers.is((Object)d));
        Assert.assertThat((Object)this.ch.getClassInfo("soba/testdata/inheritance2/E"), (Matcher)Matchers.is((Object)e));
        Assert.assertThat((Object)this.ch.getClassInfo("pkg/Unknown"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetSuperClass() {
        Assert.assertThat((Object)this.ch.getSuperClass("soba/testdata/inheritance1/D"), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/C"));
        Assert.assertThat((Object)this.ch.getSuperClass("soba/testdata/inheritance1/C"), (Matcher)Matchers.is((Object)"java/lang/Object"));
        Assert.assertThat((Object)this.ch.getSuperClass("soba/testdata/inheritance2/E"), (Matcher)Matchers.is((Object)"java/lang/Object"));
        Assert.assertThat((Object)this.ch.getSuperClass("pkg/Unknown"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testIsSamePackage() {
        Assert.assertThat((Object)this.ch.isSamePackage("soba/testdata/inheritance1/C", "soba/testdata/inheritance1/D"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.ch.isSamePackage("soba/testdata/inheritance1/C", "soba/testdata/inheritance2/F"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.ch.isSamePackage("soba/testdata/inheritance1/C", "pkg/Unknown"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.ch.isSamePackage("pkg/Unknown", "soba/testdata/inheritance1/D"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetSubtypes() {
        Collection<String> subtypesOfC = this.ch.getSubtypes("soba/testdata/inheritance1/C");
        Assert.assertThat(subtypesOfC, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"soba/testdata/inheritance1/D", "soba/testdata/inheritance2/F", "soba/testdata/inheritance1/G"}));
        Collection<String> subtypesOfE = this.ch.getSubtypes("soba/testdata/inheritance2/E");
        Assert.assertThat(subtypesOfE, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Collection<String> subtypesOfI = this.ch.getSubtypes("soba/testdata/inheritance1/I");
        Assert.assertThat(subtypesOfI, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"soba/testdata/inheritance1/D", "soba/testdata/inheritance1/K"}));
    }

    @Test
    public void testGetAllSubtypes() {
        HashSet<String> typeNames = new HashSet<String>();
        typeNames.add("soba/testdata/inheritance1/C");
        Collection<String> allSubtypesOfC = this.ch.getAllSubtypes(typeNames);
        Assert.assertThat(allSubtypesOfC, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"soba/testdata/inheritance1/C", "soba/testdata/inheritance1/D", "soba/testdata/inheritance2/H", "soba/testdata/inheritance2/F", "soba/testdata/inheritance1/G"}));
        typeNames.add("soba/testdata/inheritance1/I");
        Collection<String> allSubtypesOfCandI = this.ch.getAllSubtypes(typeNames);
        Assert.assertThat(allSubtypesOfCandI, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"soba/testdata/inheritance1/C", "soba/testdata/inheritance1/D", "soba/testdata/inheritance2/H", "soba/testdata/inheritance2/F", "soba/testdata/inheritance1/G", "soba/testdata/inheritance1/I", "soba/testdata/inheritance1/K"}));
    }

    @Test
    public void testListAllSuperTypes() {
        Collection<String> supertypesOfH = this.ch.listAllSuperTypes("soba/testdata/inheritance2/H");
        Assert.assertThat(supertypesOfH, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"soba/testdata/inheritance1/C", "soba/testdata/inheritance1/D", "soba/testdata/inheritance1/K", "soba/testdata/inheritance1/I", "java/lang/Object"}));
        Collection<String> supertypesOfI = this.ch.listAllSuperTypes("soba/testdata/inheritance1/I");
        Assert.assertThat(supertypesOfI, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"java/lang/Object"}));
    }

    @Test
    public void testGetSuperInterfaces() {
        Collection<String> superInterfaceOfH = this.ch.getSuperInterfaces("soba/testdata/inheritance1/D");
        Assert.assertThat(superInterfaceOfH, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"soba/testdata/inheritance1/I", "soba/testdata/inheritance1/K"}));
        Collection<String> superInterfaceOfC = this.ch.getSuperInterfaces("soba/testdata/inheritance1/C");
        Assert.assertThat(superInterfaceOfC, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testResolveCall01() {
        MethodInfo[] methodMain = this.ch.resolveCall("soba/testdata/inheritance2/E", "main", "([Ljava/lang/String;)V", false);
        this.checkClasses(methodMain, "soba/testdata/inheritance2/E");
    }

    @Test
    public void testResolveCall02() {
        MethodInfo[] methodsN = this.ch.resolveCall("soba/testdata/inheritance1/C", "n", "()V", true);
        this.checkClasses(methodsN, "soba/testdata/inheritance1/C", "soba/testdata/inheritance1/D", "soba/testdata/inheritance1/G", "soba/testdata/inheritance2/H");
        MethodInfo[] methodsNf = this.ch.resolveCall("soba/testdata/inheritance2/F", "n", "()V", true);
        this.checkClasses(methodsNf, "soba/testdata/inheritance2/F");
    }

    @Test
    public void testResolveCall03() {
        MethodInfo[] methodsM = this.ch.resolveCall("soba/testdata/inheritance1/D", "m", "()V", true);
        this.checkClasses(methodsM, "soba/testdata/inheritance1/D");
        MethodInfo[] methodsM2 = this.ch.resolveCall("soba/testdata/inheritance2/H", "m", "()V", true);
        this.checkClasses(methodsM2, "soba/testdata/inheritance1/D");
        MethodInfo[] methodsM3 = this.ch.resolveCall("soba/testdata/inheritance1/C", "m", "()V", true);
        this.checkClasses(methodsM3, "soba/testdata/inheritance1/C", "soba/testdata/inheritance1/D");
    }

    @Test
    public void testResolveCall04() {
        MethodInfo[] methodsPc = this.ch.resolveCall("soba/testdata/inheritance1/C", "p", "(I)V", true);
        this.checkClasses(methodsPc, "soba/testdata/inheritance1/C", "soba/testdata/inheritance2/H");
        MethodInfo[] methodsPd = this.ch.resolveCall("soba/testdata/inheritance1/C", "p", "(I)V", true);
        this.checkClasses(methodsPd, "soba/testdata/inheritance1/C", "soba/testdata/inheritance2/H");
        MethodInfo[] methodsPh = this.ch.resolveCall("soba/testdata/inheritance2/H", "p", "(I)V", true);
        this.checkClasses(methodsPh, "soba/testdata/inheritance2/H");
    }

    @Test
    public void testResolveCall05() {
        MethodInfo[] methodsQc = this.ch.resolveCall("soba/testdata/inheritance1/C", "q", "(D)V", true);
        this.checkClasses(methodsQc, "soba/testdata/inheritance1/C");
        MethodInfo[] methodsQh = this.ch.resolveCall("soba/testdata/inheritance2/H", "q", "(D)V", true);
        this.checkClasses(methodsQh, "soba/testdata/inheritance2/H");
    }

    @Test
    public void testResolveCall06() {
        MethodInfo[] methodsMi = this.ch.resolveCall("soba/testdata/inheritance1/I", "m", "()V", true);
        this.checkClasses(methodsMi, "soba/testdata/inheritance1/D");
    }

    @Test
    public void testFields() {
        Assert.assertThat((Object)this.ch.resolveField(FieldAccess.createGetField("soba/testdata/inheritance1/D", "x", "I", false)).getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/C"));
        Assert.assertThat((Object)this.ch.resolveField(FieldAccess.createGetField("soba/testdata/inheritance1/C", "x", "I", false)).getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/C"));
        Assert.assertThat((Object)this.ch.resolveField(FieldAccess.createGetField("soba/testdata/inheritance2/H", "x", "I", false)).getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance2/H"));
        Assert.assertThat((Object)this.ch.resolveField(FieldAccess.createGetField("soba/testdata/inheritance1/I", "x", "I", true)).getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/I"));
        Assert.assertThat((Object)this.ch.resolveField(FieldAccess.createGetField("soba/testdata/inheritance1/J", "x", "I", true)).getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/J"));
        Assert.assertThat((Object)this.ch.resolveField(FieldAccess.createGetField("soba/testdata/inheritance1/K", "x", "I", true)).getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/I"));
    }

    private void checkClasses(MethodInfo[] resolved, String ... classNames) {
        ArrayList<String> classes = new ArrayList<String>();
        MethodInfo[] methodInfoArray = resolved;
        int n = resolved.length;
        int n2 = 0;
        while (n2 < n) {
            MethodInfo m = methodInfoArray[n2];
            classes.add(m.getClassName());
            ++n2;
        }
        Assert.assertThat(classes, (Matcher)Matchers.containsInAnyOrder((Object[])classNames));
    }

    @Test
    public void testFreeze() {
        Assert.assertThat((Object)this.ch.isFrozen(), (Matcher)Matchers.is((Object)false));
        this.ch.freeze();
        Assert.assertThat((Object)this.ch.isFrozen(), (Matcher)Matchers.is((Object)true));
        try {
            this.ch.registerClass(f);
            Assert.fail();
        }
        catch (ClassHierarchy.FrozenHierarchyException frozenHierarchyException) {
            // empty catch block
        }
        try {
            this.ch.registerInterfaces("soba/testdata/inheritance2/F", new ArrayList<String>());
            Assert.fail();
        }
        catch (ClassHierarchy.FrozenHierarchyException frozenHierarchyException) {
            // empty catch block
        }
        try {
            this.ch.registerSuperClass("soba/testdata/inheritance1/C", "java/lang/Object");
            Assert.fail();
        }
        catch (ClassHierarchy.FrozenHierarchyException frozenHierarchyException) {
            // empty catch block
        }
        try {
            this.ch.registerSubtype("pkg/NewChild", "soba/testdata/inheritance1/C");
            Assert.fail();
        }
        catch (ClassHierarchy.FrozenHierarchyException frozenHierarchyException) {
            // empty catch block
        }
    }
}

