/*
 * Decompiled with CFR 0.152.
 */
package soba.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import soba.core.ClassInfo;
import soba.core.ExampleProgram;

public class ClassInfoTest
implements ExampleProgram {
    @Test
    public void testClassInfo01() throws Exception {
        String fileName = "bin/soba/testdata/inheritance1/D.class";
        ClassInfo c = new ClassInfo(fileName, new FileInputStream(fileName));
        Assert.assertThat((Object)c.getPackageName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1"));
        Assert.assertThat((Object)c.getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/D"));
        Assert.assertThat((Object)c.getSuperClass(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/C"));
        Assert.assertThat(c.getInterfaces(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"soba/testdata/inheritance1/I", "soba/testdata/inheritance1/K"}));
        Assert.assertThat((Object)c.getHash(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.getClassDirPath(), (Matcher)Matchers.is((Object)("soba" + File.separator + "testdata" + File.separator + "inheritance1")));
        Assert.assertThat((Object)c.getClassFileName(), (Matcher)Matchers.is((Object)fileName));
        Assert.assertThat((Object)c.getSourceFileName(), (Matcher)Matchers.is((Object)("soba" + File.separator + "testdata" + File.separator + "inheritance1" + File.separator + "D.java")));
        Assert.assertThat((Object)c.getLabel(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)c.isLibrary(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)c.getMethodCount(), (Matcher)Matchers.is((Object)11));
        Assert.assertThat(c.getMethods(), (Matcher)Matchers.hasSize((int)11));
        Assert.assertThat((Object)c.getMethod(0), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("m", "()V"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("n", "()V"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("x", "(I)V"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("example", "(IJDLjava/lang/String;)I"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("toString", "()Ljava/lang/String;"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("notExist", "()V"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)c.getFieldCount(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat(c.getFields(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testClassInfo02() throws Exception {
        String fileName = "bin/soba/testdata/inheritance2/H.class";
        ClassInfo c = new ClassInfo(fileName, new FileInputStream(fileName), "label");
        Assert.assertThat((Object)c.getPackageName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance2"));
        Assert.assertThat((Object)c.getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance2/H"));
        Assert.assertThat((Object)c.getSuperClass(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/D"));
        Assert.assertThat(c.getInterfaces(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)c.getHash(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.getClassDirPath(), (Matcher)Matchers.is((Object)("soba" + File.separator + "testdata" + File.separator + "inheritance2")));
        Assert.assertThat((Object)c.getClassFileName(), (Matcher)Matchers.is((Object)fileName));
        Assert.assertThat((Object)c.getSourceFileName(), (Matcher)Matchers.is((Object)("soba" + File.separator + "testdata" + File.separator + "inheritance2" + File.separator + "H.java")));
        Assert.assertThat((Object)c.getLabel(), (Matcher)Matchers.is((Object)"label"));
        Assert.assertThat((Object)c.isLibrary(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)c.getMethodCount(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat(c.getMethods(), (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)c.getMethod(0), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("n", "()V"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("p", "(I)V"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("q", "(D)V"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findMethod("<init>", "()V"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.getFieldCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat(c.getFields(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)c.getField(0), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)c.findField("x", "I"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testLibrary01() throws IOException {
        String fileName = "bin/soba/testdata/inheritance2/H.class";
        ClassInfo c = ClassInfo.createLibraryClass(fileName, new FileInputStream(fileName));
        Assert.assertThat((Object)c.isLibrary(), (Matcher)Matchers.is((Object)true));
    }
}

