/*
 * Decompiled with CFR 0.152.
 */
package soba.core;

import org.objectweb.asm.tree.FieldNode;
import soba.core.ClassInfo;
import soba.core.signature.TypeResolver;

public class FieldInfo {
    private ClassInfo owner;
    private FieldNode fieldNode;
    private String typeName;

    public FieldInfo(ClassInfo owner, FieldNode fieldNode) {
        this.owner = owner;
        this.fieldNode = fieldNode;
        this.typeName = null;
    }

    public String getPackageName() {
        return this.owner.getPackageName();
    }

    public String getClassName() {
        return this.owner.getClassName();
    }

    public String getFieldName() {
        return this.fieldNode.name;
    }

    public String getDescriptor() {
        return this.fieldNode.desc;
    }

    public String getFieldTypeName() {
        if (this.typeName == null) {
            this.typeName = this.fieldNode.signature != null ? TypeResolver.getTypeName(this.fieldNode.signature) : TypeResolver.getTypeName(this.fieldNode.desc);
        }
        return this.typeName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClassName());
        builder.append(".");
        builder.append(this.getFieldName());
        builder.append(": ");
        builder.append(this.getFieldTypeName());
        return builder.toString();
    }
}

